/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0012\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0005\u00031\u0001\u0011$\u0001M\u0001;\u0003I\u00115D\u0005\u0007\u0011\u0005iA!\u0003\u0002\n\u0003a\u0011\u00014A\u0005\u0004\u0011\u000bi\u0011\u0001'\u0001R\u0007\u0005A1!\n\u000e\u0005\u0017!%QbE\u0005\u0007\u0013\u0015\u0001Z!\u0006\u0002\r\u0002a\u0011\u0001D\u0001I\u0006+%Ia!C\u0003\u0011\fU\u0011A\u0012\u0001\r\u00031\ta\t\u0001G\u0003\u0019\u000be\u0019\u0001BB\u0007\u00021\u001b)c\u0002\"\u0006\t\u000f5\u0019\u0011\"\u0001C\u00021\u001fI2\u0001\u0003\u0004\u000e\u0003a5\u0011d\u0001\u0005\t\u001b\u0005A\n\"K\u0004\u0005\u0003\"A9!D\u0001\u0019\tE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/PluginURLClassLoader;", "Ljava/lang/ClassLoader;", "urls", "", "Ljava/net/URL;", "parent", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V", "childClassLoader", "Lorg/jetbrains/kotlin/cli/jvm/PluginURLClassLoader$SelfThenParentURLClassLoader;", "getResources", "Ljava/util/Enumeration;", "kotlin.jvm.PlatformType", "name", "", "loadClass", "Ljava/lang/Class;", "resolve", "", "SelfThenParentURLClassLoader"}, moduleName="kotlin-compiler")
public final class PluginURLClassLoader
extends ClassLoader {
    private final SelfThenParentURLClassLoader childClassLoader;

    @Override
    @NotNull
    protected synchronized Class<?> loadClass(@NotNull String name, boolean resolve2) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull(name, "name");
        try {
            clazz = this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz2 = super.loadClass(name, resolve2);
            Intrinsics.checkExpressionValueIsNotNull(clazz2, "super.loadClass(name, resolve)");
            clazz = clazz2;
        }
        return clazz;
    }

    @Override
    public Enumeration<URL> getResources(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.childClassLoader.getResources(name);
    }

    public PluginURLClassLoader(@NotNull URL[] urls, @NotNull ClassLoader parent2) {
        Intrinsics.checkParameterIsNotNull(urls, "urls");
        Intrinsics.checkParameterIsNotNull(parent2, "parent");
        super(Thread.currentThread().getContextClassLoader());
        this.childClassLoader = new SelfThenParentURLClassLoader(urls, parent2);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0012\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0001\u000b\u0005Aq\u0001B\u0001\r\u0001e\t\u0001\u0014AQ\u000e\u0013\u0019A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002\u0013\rA)!D\u0001\u0019\u0007E\u001b\u0011\u0001c\u0002&\u0015\u0011Y\u0001\"B\u0007\u0004\u0013\u0005!\u0019\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u0007S)!1\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\n\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/PluginURLClassLoader$SelfThenParentURLClassLoader;", "Ljava/net/URLClassLoader;", "urls", "", "Ljava/net/URL;", "onFail", "Ljava/lang/ClassLoader;", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V", "getOnFail", "()Ljava/lang/ClassLoader;", "findClass", "Ljava/lang/Class;", "name", ""}, moduleName="kotlin-compiler")
    private static final class SelfThenParentURLClassLoader
    extends URLClassLoader {
        @NotNull
        private final ClassLoader onFail;

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) {
            Class<?> clazz;
            Intrinsics.checkParameterIsNotNull(name, "name");
            Class<?> loaded = this.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            try {
                Class<?> clazz2 = super.findClass(name);
                Intrinsics.checkExpressionValueIsNotNull(clazz2, "super.findClass(name)");
                clazz = clazz2;
            }
            catch (ClassNotFoundException e) {
                Class<?> clazz3 = this.onFail.loadClass(name);
                Intrinsics.checkExpressionValueIsNotNull(clazz3, "onFail.loadClass(name)");
                clazz = clazz3;
            }
            return clazz;
        }

        @NotNull
        public final ClassLoader getOnFail() {
            return this.onFail;
        }

        public SelfThenParentURLClassLoader(@NotNull URL[] urls, @NotNull ClassLoader onFail) {
            Intrinsics.checkParameterIsNotNull(urls, "urls");
            Intrinsics.checkParameterIsNotNull(onFail, "onFail");
            super(urls, (ClassLoader)null);
            this.onFail = onFail;
        }
    }
}

