/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.MethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.LocalVariablesManager;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"G\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011C)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u00061\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002K1!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\u0013\u001f\t\u0005AI!D\u0001\u0019\u0005e\u0019\u0001rA\u0007\u00021\u0011I\u0012\u0002C\u0003\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005A\"\u0001\u0007\u0004\u0019\fe\u0019\u0001RB\u0007\u00021\u001dI2\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\t\u001b\u0005A\u0012\"\n\u0010\u0005\u0003!MQ\"\u0001\r\u00033\rA9!D\u0001\u0019\teI\u0001\"B\u0007\b\u0013\u0015IA!\u0003\u0002\n\u0003a\u0011\u0001D\u0002M\u00063\rAi!D\u0001\u0019\u000fe\u0019\u0001rB\u0007\u00021!I2\u0001#\u0005\u000e\u0003aIQE\u0007\u0003\u0002\u0011)i\u0011\u0001\u0007\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rA)\"D\u0001\u0019\u0017eI\u0001\"B\u0007\b\u0013\u0015IA!\u0003\u0002\n\u0003a\u0011\u0001D\u0002M\u00063\rAi!D\u0001\u0019\u000f\u0015RB!\u0001E\f\u001b\u0005A\"!G\u0002\t\b5\t\u0001\u0004B\r\n\u0011\u0015iq!C\u0003\n\t%\u0011\u0011\"\u0001\r\u00031\u0019AZ!G\u0002\t\u00195\t\u0001\u0004C\r\u0004\u0011#i\u0011\u0001G\u0005&5\u0011\t\u0001\u0012D\u0007\u00021\tI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001\u0005\u000e\u001b\u0005A2\"G\u0005\t\u000b59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\ra-\u0011d\u0001E\u0007\u001b\u0005Ar!\n\u0010\u0005\u0003!mQ\"\u0001\r\u00033\rA9!D\u0001\u0019\teI\u0001\"B\u0007\b\u0013\u0015IA!\u0003\u0002\n\u0003a\u0011\u0001D\u0002M\u00063\rAi!D\u0001\u0019\u000fe\u0019\u0001\u0002D\u0007\u00021!I2\u0001#\u0005\u000e\u0003aI\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "transformAfterInlineCallMarker", "actions", "", "Lkotlin/Function0;", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "inlineMarker", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "localVariablesManager", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "transformBeforeInlineCallMarker", "transformBreakContinueGotos", "fixStackContext", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "transformRestoreStackMarker", "marker", "transformSaveRestoreStackMarkers", "context", "transformSaveStackMarker"}, moduleName="kotlin-compiler")
public final class FixStackMethodTransformer
extends MethodTransformer {
    /*
     * WARNING - void declaration
     */
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        AbstractInsnNode marker;
        Object analyzer;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        FixStackContext context = new FixStackContext(methodNode);
        if (!context.hasAnyMarkers()) {
            return;
        }
        if (!context.getConsistentInlineMarkers()) {
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
            Sequence sequence2 = new InsnSequence(insnList);
            for (Object element$iv : $receiver$iv) {
                AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
                if (InlineCodegenUtil.isInlineMarker(insnNode)) {
                    methodNode.instructions.remove(insnNode);
                }
            }
        }
        if (context.isAnalysisRequired()) {
            void $receiver$iv2;
            Object element$iv;
            analyzer = new FixStackAnalyzer(internalClassName, methodNode, context);
            ((MethodAnalyzer)analyzer).analyze();
            methodNode.maxStack += ((FixStackAnalyzer)analyzer).getMaxExtraStackSize();
            ArrayList<Function0> actions = CollectionsKt.arrayListOf(new Function0[0]);
            this.transformBreakContinueGotos(methodNode, context, (List<Function0<Unit>>)actions, (FixStackAnalyzer)analyzer);
            this.transformSaveRestoreStackMarkers(methodNode, context, (List<Function0<Unit>>)actions, (FixStackAnalyzer)analyzer);
            element$iv = actions;
            for (Object element$iv2 : $receiver$iv2) {
                Function0 it = (Function0)element$iv2;
                it.invoke();
            }
        }
        analyzer = context.getFakeAlwaysTrueIfeqMarkers();
        for (Object element$iv : $receiver$iv) {
            marker = (AbstractInsnNode)element$iv;
            StackTransformationUtilsKt.replaceAlwaysTrueIfeqWithGoto(methodNode, marker);
        }
        $receiver$iv = context.getFakeAlwaysFalseIfeqMarkers();
        for (Object element$iv : $receiver$iv) {
            marker = (AbstractInsnNode)element$iv;
            StackTransformationUtilsKt.removeAlwaysFalseIfeq(methodNode, marker);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformBreakContinueGotos(MethodNode methodNode, FixStackContext fixStackContext, List<Function0<Unit>> actions, FixStackAnalyzer analyzer) {
        void $receiver$iv;
        Iterable iterable = fixStackContext.getBreakContinueGotoNodes();
        for (Object element$iv : $receiver$iv) {
            int expectedStackSize;
            JumpInsnNode gotoNode = (JumpInsnNode)element$iv;
            int gotoIndex = methodNode.instructions.indexOf(gotoNode);
            int labelIndex = methodNode.instructions.indexOf(gotoNode.label);
            int DEAD_CODE = -1;
            Frame frame = analyzer.getFrames()[gotoIndex];
            int actualStackSize = frame != null ? frame.getStackSize() : DEAD_CODE;
            Frame frame2 = analyzer.getFrames()[labelIndex];
            int n = expectedStackSize = frame2 != null ? frame2.getStackSize() : DEAD_CODE;
            if (actualStackSize != DEAD_CODE && expectedStackSize != DEAD_CODE) {
                Frame frame3;
                Unit unit;
                boolean bl = expectedStackSize <= actualStackSize;
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Label at " + labelIndex + ", jump at " + gotoIndex + ": stack underflow: " + expectedStackSize + " > " + actualStackSize;
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                if (analyzer.getFrames()[gotoIndex] == null) {
                    Intrinsics.throwNpe();
                }
                actions.add(new Function0<Unit>(gotoNode, expectedStackSize, frame3, methodNode, analyzer, actions){
                    final /* synthetic */ JumpInsnNode $gotoNode;
                    final /* synthetic */ int $expectedStackSize;
                    final /* synthetic */ Frame $frame;
                    final /* synthetic */ MethodNode $methodNode$inlined;
                    final /* synthetic */ FixStackAnalyzer $analyzer$inlined;
                    final /* synthetic */ List $actions$inlined;

                    public final void invoke() {
                        AbstractInsnNode abstractInsnNode = this.$gotoNode.getPrevious();
                        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "gotoNode.getPrevious()");
                        StackTransformationUtilsKt.replaceMarkerWithPops(this.$methodNode$inlined, abstractInsnNode, this.$expectedStackSize, this.$frame);
                    }
                    {
                        this.$gotoNode = jumpInsnNode;
                        this.$expectedStackSize = n;
                        this.$frame = frame;
                        this.$methodNode$inlined = methodNode;
                        this.$analyzer$inlined = fixStackAnalyzer;
                        this.$actions$inlined = list;
                        super(0);
                    }
                });
                continue;
            }
            if (actualStackSize != DEAD_CODE && expectedStackSize == DEAD_CODE) {
                throw (Throwable)((Object)new AssertionError((Object)("Live jump " + gotoIndex + " to dead label " + labelIndex)));
            }
            AbstractInsnNode marker = gotoNode.getPrevious();
            actions.add(new Function0<Unit>(marker, methodNode, analyzer, actions){
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ MethodNode $methodNode$inlined;
                final /* synthetic */ FixStackAnalyzer $analyzer$inlined;
                final /* synthetic */ List $actions$inlined;

                public final void invoke() {
                    this.$methodNode$inlined.instructions.remove(this.$marker);
                }
                {
                    this.$marker = abstractInsnNode;
                    this.$methodNode$inlined = methodNode;
                    this.$analyzer$inlined = fixStackAnalyzer;
                    this.$actions$inlined = list;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSaveRestoreStackMarkers(MethodNode methodNode, FixStackContext context, List<Function0<Unit>> actions, FixStackAnalyzer analyzer) {
        void $receiver$iv;
        LocalVariablesManager localVariablesManager = new LocalVariablesManager(context, methodNode);
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        Sequence sequence2 = new InsnSequence(insnList);
        for (Object element$iv : $receiver$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(marker);
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.SAVE_STACK_BEFORE_TRY)) {
                this.transformSaveStackMarker(methodNode, actions, analyzer, marker, localVariablesManager);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH)) {
                this.transformRestoreStackMarker(methodNode, actions, marker, localVariablesManager);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(marker)) {
                this.transformBeforeInlineCallMarker(methodNode, actions, analyzer, marker, localVariablesManager);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(marker)) continue;
            this.transformAfterInlineCallMarker(methodNode, actions, analyzer, marker, localVariablesManager);
        }
    }

    private final void transformSaveStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        List<BasicValue> savedStackValues = analyzer.getSavedStacks().get(marker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForSaveStackMarker(marker, savedStackValues);
            actions.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$marker, this.$savedStackDescriptor, false);
                }
                {
                    this.$methodNode = methodNode;
                    this.$marker = abstractInsnNode;
                    this.$savedStackDescriptor = savedStackDescriptor;
                    super(0);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForSaveStackMarker(marker, CollectionsKt.emptyList());
            actions.add(new Function0<Unit>(methodNode, marker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$marker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$marker = abstractInsnNode;
                    super(0);
                }
            });
        }
    }

    private final void transformRestoreStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getSavedStackDescriptor(marker);
        actions.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
            final /* synthetic */ MethodNode $methodNode;
            final /* synthetic */ AbstractInsnNode $marker;
            final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

            public final void invoke() {
                StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$marker, this.$savedStackDescriptor);
            }
            {
                this.$methodNode = methodNode;
                this.$marker = abstractInsnNode;
                this.$savedStackDescriptor = savedStackDescriptor;
                super(0);
            }
        });
        localVariablesManager.markRestoreStackMarkerEmitted(marker);
    }

    /*
     * WARNING - void declaration
     */
    private final void transformAfterInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getBeforeInlineDescriptor(inlineMarker);
        FixStackAnalyzer.FixStackFrame afterInlineFrame = (FixStackAnalyzer.FixStackFrame)analyzer.getFrame(inlineMarker);
        if (afterInlineFrame != null && savedStackDescriptor.isNotEmpty()) {
            Unit unit;
            boolean bl = afterInlineFrame.getStackSize() <= 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Inline method should not leave more than 1 value on stack";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            if (afterInlineFrame.getStackSize() == 1) {
                List<BasicValue> afterInlineStackValues = afterInlineFrame.getStackContent();
                BasicValue returnValue = CollectionsKt.last(afterInlineStackValues);
                int returnValueLocalVarIndex = localVariablesManager.createReturnValueVariable(returnValue);
                actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor, returnValue, returnValueLocalVarIndex){
                    final /* synthetic */ MethodNode $methodNode;
                    final /* synthetic */ AbstractInsnNode $inlineMarker;
                    final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                    final /* synthetic */ BasicValue $returnValue;
                    final /* synthetic */ int $returnValueLocalVarIndex;

                    public final void invoke() {
                        StackTransformationUtilsKt.restoreStackWithReturnValue(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor, this.$returnValue, this.$returnValueLocalVarIndex);
                    }
                    {
                        this.$methodNode = methodNode;
                        this.$inlineMarker = abstractInsnNode;
                        this.$savedStackDescriptor = savedStackDescriptor;
                        this.$returnValue = basicValue;
                        this.$returnValueLocalVarIndex = n;
                        super(0);
                    }
                });
            } else {
                actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                    final /* synthetic */ MethodNode $methodNode;
                    final /* synthetic */ AbstractInsnNode $inlineMarker;
                    final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                    public final void invoke() {
                        StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor);
                    }
                    {
                        this.$methodNode = methodNode;
                        this.$inlineMarker = abstractInsnNode;
                        this.$savedStackDescriptor = savedStackDescriptor;
                        super(0);
                    }
                });
            }
        } else {
            actions.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    super(0);
                }
            });
        }
        localVariablesManager.markAfterInlineMarkerEmitted(inlineMarker);
    }

    private final void transformBeforeInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        List<BasicValue> savedStackValues = analyzer.getSavedStacks().get(inlineMarker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, savedStackValues);
            actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor, false);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    this.$savedStackDescriptor = savedStackDescriptor;
                    super(0);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, CollectionsKt.emptyList());
            actions.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    super(0);
                }
            });
        }
    }
}

