/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.TextOutput;
import com.google.dart.compiler.util.TextOutputImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.sourceMap.JsSourceGenerationVisitor;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tAQ\u0001\u0003\u0014\u0019\u0001I\u0012\u0001'\u0001\u001e\u0003\u000f!\u0011u\u0002\u0003\u0003\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "Fail", "Success"}, moduleName="kotlin-compiler")
public abstract class TranslationResult {
    @NotNull
    private final Diagnostics diagnostics;

    @NotNull
    public final Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    protected TranslationResult(@NotNull Diagnostics diagnostics) {
        Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
        this.diagnostics = diagnostics;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0011\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001A\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Fail;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V"}, moduleName="kotlin-compiler")
    public static final class Fail
    extends TranslationResult {
        public Fail(@NotNull Diagnostics diagnostics) {
            Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
            super(diagnostics);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"O\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005N\u0012b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0004\t\u00055!\u0011BA\u0005\u00021\rA*!C\u0002\t\b5\t\u0001\u0004B\u0005\u0004\u0011\u0013i\u0011\u0001G\u0003\n\u0007!-Q\"\u0001\r\u0007#\u000e\t\u0001RB\u0013\u0004\u0011!i\u0011\u0001'\u0005&\u001b\u0011\t\u0001\u0002C\u0007\u00021#I2\u0001C\u0005\u000e\u0003aM\u0011\u0004\u0002\u0005\u000b\u001b\ta\t\u0001'\u0006&#!YQ\"\u0001M\f3\rAA\"D\u0001\u0019\u001ae!\u0001\"D\u0007\u0003\u0019\u0003AJ\"\u0007\u0003\t\u001c5\u0011A\u0012\u0001M\rS\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!-Q\"\u0001\r\u0007#\u000e\tQ\u0001A\u0015\u000b\t\rC\u0001rA\u0007\u00021\u0011\t6\u0001B\u0003\u0001\u001b\t!q\u0001c\u0004"}, strings={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Success;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "config", "Lorg/jetbrains/kotlin/js/config/Config;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "program", "Lcom/google/dart/compiler/backend/js/ast/JsProgram;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/js/config/Config;Ljava/util/List;Lcom/google/dart/compiler/backend/js/ast/JsProgram;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "getProgram", "()Lcom/google/dart/compiler/backend/js/ast/JsProgram;", "getCode", "", "output", "Lcom/google/dart/compiler/util/TextOutput;", "sourceMapBuilder", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilder;", "getOutputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputFile", "Ljava/io/File;", "outputPrefixFile", "outputPostfixFile"}, moduleName="kotlin-compiler")
    public static final class Success
    extends TranslationResult {
        private final Config config;
        private final List<KtFile> files;
        @NotNull
        private final JsProgram program;
        private final ModuleDescriptor moduleDescriptor;

        @NotNull
        public final String getCode() {
            return this.getCode(new TextOutputImpl(), null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OutputFileCollection getOutputFiles(@NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile) {
            Object metaFileName;
            Map.Entry it;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object object;
            Object prefix;
            Intrinsics.checkParameterIsNotNull(outputFile, "outputFile");
            TextOutputImpl output = new TextOutputImpl();
            SourceMap3Builder sourceMapBuilder = this.config.isSourcemap() ? new SourceMap3Builder(outputFile, output, new SourceMapBuilderConsumer()) : (SourceMap3Builder)null;
            String code = this.getCode(output, sourceMapBuilder);
            Object object2 = outputPrefixFile;
            if (object2 == null || (object2 = FileUtilsKt.readTextOrEmpty((File)object2)) == null) {
                object2 = prefix = "";
            }
            if ((object = outputPostfixFile) == null || (object = FileUtilsKt.readTextOrEmpty((File)object)) == null) {
                object = "";
            }
            Object postfix = object;
            Iterable iterable = this.files;
            void var11_10 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                KtFile ktFile = (KtFile)item$iv$iv;
                void var20_16 = destination$iv$iv;
                VirtualFile virtualFile = ((PsiFileImpl)((Object)it)).getOriginalFile().getVirtualFile();
                File file = virtualFile == null ? new File(((KtFile)((Object)it)).getName()) : VfsUtilCore.virtualToIoFile(virtualFile);
                var20_16.add(file);
            }
            List sourceFiles = (List)destination$iv$iv;
            String string = outputFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "outputFile.getName()");
            SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles, string, (String)prefix + code + (String)postfix);
            ArrayList<OutputFile> outputFiles = CollectionsKt.arrayListOf(jsFile);
            if (this.config.isMetaInfo()) {
                String string2 = outputFile.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "outputFile.getName()");
                metaFileName = KotlinJavascriptMetadataUtils.INSTANCE.replaceSuffix(string2);
                String string3 = this.config.getModuleId();
                Intrinsics.checkExpressionValueIsNotNull(string3, "config.getModuleId()");
                String metaFileContent = KotlinJavascriptSerializationUtil.INSTANCE.metadataAsString(string3, this.moduleDescriptor);
                ArrayList sourceFilesForMetaFile = new ArrayList(sourceFiles);
                SimpleOutputFile jsMetaFile = new SimpleOutputFile(sourceFilesForMetaFile, (String)metaFileName, metaFileContent);
                outputFiles.add(jsMetaFile);
            }
            if (this.config.isKjsm()) {
                void $receiver$iv2;
                metaFileName = KotlinJavascriptSerializationUtil.INSTANCE.toContentMap(this.moduleDescriptor);
                Iterator<Object> iterator2 = MapsKt.iterator($receiver$iv2);
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    it = element$iv = (Map.Entry)iterator2.next();
                    outputFiles.add(new SimpleOutputBinaryFile(CollectionsKt.emptyList(), this.config.getModuleId() + '/' + (String)it.getKey(), (byte[])it.getValue()));
                }
            }
            if (sourceMapBuilder != null) {
                sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount((CharSequence)prefix));
                String string4 = sourceMapBuilder.getOutFile().getName();
                Intrinsics.checkExpressionValueIsNotNull(string4, "sourceMapBuilder.getOutFile().getName()");
                String string5 = sourceMapBuilder.build();
                Intrinsics.checkExpressionValueIsNotNull(string5, "sourceMapBuilder.build()");
                SimpleOutputFile sourceMapFile = new SimpleOutputFile(sourceFiles, string4, string5);
                outputFiles.add(sourceMapFile);
            }
            return new SimpleOutputFileCollection((List<? extends OutputFile>)outputFiles);
        }

        private final String getCode(TextOutput output, SourceMapBuilder sourceMapBuilder) {
            this.program.accept(new JsSourceGenerationVisitor(output, sourceMapBuilder));
            return output.toString();
        }

        @NotNull
        public final JsProgram getProgram() {
            return this.program;
        }

        public Success(@NotNull Config config, @NotNull List<? extends KtFile> files, @NotNull JsProgram program, @NotNull Diagnostics diagnostics, @NotNull ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkParameterIsNotNull(config, "config");
            Intrinsics.checkParameterIsNotNull(files, "files");
            Intrinsics.checkParameterIsNotNull(program, "program");
            Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
            Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
            super(diagnostics);
            this.config = config;
            this.files = files;
            this.program = program;
            this.moduleDescriptor = moduleDescriptor;
        }
    }
}

