/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u0005f\u0011\"\u0003\u0005\u0002\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001M\u00031\u0007\t6!\u0001\u0005\u0004K9!1\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0003\t\f5\u0019\u0011\"\u0001C\u00021\u0019)c\u0002B\u0006\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001'\u0004\u001a\u000b!-QbA\u0005\u0002\t\u0007Ab!\n\b\u0005\u0017!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000fe)\u00012B\u0007\u0004\u0013\u0005!\u0019\u0001\u0007\u0004*\u001b\u0011\t\u0005\u0002C\u0001\u000e\u000f%\u0011\u0011\"\u0001\r\u0003\u0013\tI\u0011\u0001'\u0002\u0019\u0004E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/NameReplacingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "replaceMap", "", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "(Ljava/util/Map;)V", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsLabel;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "Lcom/google/dart/compiler/backend/js/ast/JsVars$JsVar;"}, moduleName="kotlin-compiler")
public final class NameReplacingVisitor
extends JsVisitorWithContextImpl {
    private final Map<JsName, JsExpression> replaceMap;

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression replacement = MapsKt.get(this.replaceMap, x.getName());
        if (replacement == null) {
            return;
        }
        ctx.replaceMe((JsNode)replacement);
    }

    public void endVisit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression replacement = this.replaceMap.get(x.getName());
        if (replacement instanceof HasName) {
            JsVars.JsVar replacementVar = new JsVars.JsVar(((HasName)((Object)replacement)).getName(), x.getInitExpression());
            ctx.replaceMe((JsNode)replacementVar);
        }
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression replacement = this.replaceMap.get(x.getName());
        if (replacement instanceof HasName) {
            JsLabel replacementLabel = new JsLabel(((HasName)((Object)replacement)).getName(), x.getStatement());
            ctx.replaceMe((JsNode)replacementLabel);
        }
    }

    public NameReplacingVisitor(@NotNull Map<JsName, ? extends JsExpression> replaceMap) {
        Intrinsics.checkParameterIsNotNull(replaceMap, "replaceMap");
        this.replaceMap = replaceMap;
    }
}

