/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.common.collect.ImmutableCollection;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtBinaryExpression expression;
    protected final AccessTranslator accessTranslator;
    protected final boolean isVariableReassignment;
    @NotNull
    protected final JsExpression right;

    public static boolean isAssignmentOperator(KtToken operationToken) {
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression)) {
            JsExpression jsExpression = IntrinsicAssignmentTranslator.doTranslate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = OverloadedAssignmentTranslator.doTranslate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
        }
        return jsExpression;
    }

    protected AssignmentTranslator(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context.bindingContext(), expression);
        KtExpression left = expression.getLeft();
        assert (left != null) : "No left-hand side: " + expression.getText();
        JsBlock rightBlock = new JsBlock();
        this.right = TranslationUtils.translateRightExpression(context, expression, rightBlock);
        if (AssignmentTranslator.isValProperty(left, context)) {
            KtSimpleNameExpression simpleName = PsiUtils.getSimpleName(left);
            assert (simpleName != null);
            this.accessTranslator = BackingFieldAccessTranslator.newInstance(simpleName, context);
        } else {
            this.accessTranslator = AccessTranslationUtils.getAccessTranslator(left, this.context(), !rightBlock.isEmpty());
        }
        context.addStatementsToCurrentBlockFrom(rightBlock);
    }

    private static boolean isValProperty(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "isValProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "isValProperty"));
        }
        KtSimpleNameExpression simpleNameExpression = PsiUtils.getSimpleName(expression);
        if (simpleNameExpression != null) {
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression);
            return descriptor2 instanceof PropertyDescriptor && !((PropertyDescriptor)descriptor2).isVar();
        }
        return false;
    }
}

