/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtLambdaExpression
extends KtExpressionImpl {
    public KtLambdaExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtLambdaExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtLambdaExpression", "accept"));
        }
        return visitor2.visitLambdaExpression(this, data);
    }

    @NotNull
    public KtFunctionLiteral getFunctionLiteral() {
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)this.findChildByType(KtNodeTypes.FUNCTION_LITERAL);
        if (ktFunctionLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getFunctionLiteral"));
        }
        return ktFunctionLiteral;
    }

    @NotNull
    public List<KtParameter> getValueParameters() {
        List<KtParameter> list = this.getFunctionLiteral().getValueParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getValueParameters"));
        }
        return list;
    }

    @Nullable
    public KtBlockExpression getBodyExpression() {
        return this.getFunctionLiteral().getBodyExpression();
    }

    public boolean hasDeclaredReturnType() {
        return this.getFunctionLiteral().getTypeReference() != null;
    }

    @NotNull
    public KtElement asElement() {
        KtLambdaExpression ktLambdaExpression = this;
        if (ktLambdaExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "asElement"));
        }
        return ktLambdaExpression;
    }

    @NotNull
    public ASTNode getLeftCurlyBrace() {
        ASTNode aSTNode = this.getFunctionLiteral().getNode().findChildByType(KtTokens.LBRACE);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getLeftCurlyBrace"));
        }
        return aSTNode;
    }

    @Nullable
    public ASTNode getRightCurlyBrace() {
        return this.getFunctionLiteral().getNode().findChildByType(KtTokens.RBRACE);
    }
}

