/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0011\u0019\u0017\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\u0015\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001DB\u0013\u0011\u0011\u001bi!\u0001$\u0001\u0019\u000fe\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\u0004\u001b\u0005A\n\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/ConstModifierChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkCanBeConst", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "constModifierPsiElement", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;"}, moduleName="kotlin-compiler")
public final class ConstModifierChecker
implements DeclarationChecker {
    public static final ConstModifierChecker INSTANCE;
    public static final ConstModifierChecker INSTANCE$;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        PsiElement constModifierPsiElement;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (!(descriptor2 instanceof VariableDescriptor) || !declaration.hasModifier(KtTokens.CONST_KEYWORD)) {
            return;
        }
        KtModifierList ktModifierList = declaration.getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = ktModifierList.getModifier(KtTokens.CONST_KEYWORD);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement3 = constModifierPsiElement = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull(psiElement3, "constModifierPsiElement");
        Diagnostic diagnostic = this.checkCanBeConst(declaration, psiElement3, (VariableDescriptor)descriptor2);
        if (diagnostic != null) {
            diagnosticHolder.report(diagnostic);
        }
    }

    @Nullable
    public final Diagnostic checkCanBeConst(@NotNull KtDeclaration declaration, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(constModifierPsiElement, "constModifierPsiElement");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2.isVar()) {
            return Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, "vars");
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.OBJECT) ^ true) {
            return Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement);
        }
        if (!(declaration instanceof KtProperty) || !(descriptor2 instanceof PropertyDescriptor)) {
            return null;
        }
        if (((KtProperty)declaration).hasDelegate()) {
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration).getDelegate();
            if (ktPropertyDelegate == null) {
                Intrinsics.throwNpe();
            }
            return Errors.CONST_VAL_WITH_DELEGATE.on(ktPropertyDelegate);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (!propertyGetterDescriptor.isDefault()) {
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration).getGetter();
                if (ktPropertyAccessor == null) {
                    Intrinsics.throwNpe();
                }
                return Errors.CONST_VAL_WITH_GETTER.on(ktPropertyAccessor);
            }
        }
        if (!ConstUtilKt.canBeUsedForConstVal(((PropertyDescriptor)descriptor2).getType())) {
            return Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor2).getType());
        }
        if (((KtProperty)declaration).getInitializer() == null) {
            return Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement);
        }
        if (((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null) {
            KtExpression ktExpression = ((KtProperty)declaration).getInitializer();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            return Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((KtExpression)((PsiElement)ktExpression));
        }
        return null;
    }

    private ConstModifierChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new ConstModifierChecker();
    }
}

