/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.OverridingUtilsKt;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartSet;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"-\u0015\u0001Q!\u0001\u0005\u0012\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0011\u000b\u0005!\u0011!B\u0001\t\u001f\u0015\u0001Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ\"\u0005\u0005\u0001\u001b\u0011I!!C\u0001%\u0003a\u0005\u0011\u0003\u0002\u0003\u0001\u0011\u0005)\u0012\u0001g\u0001\u0016\u0003\u0011\n\u0011kA\u0001\t\u0005Q\u001b)!D\t\t\u00075!\u0011BA\u0005\u0002I\u0005A:!\u0005\u0003\u0005\u0001!\tQ#\u0001M\u0002+\u0005!\u0013!U\u0002\u0002\u0011\u0011!6QAG \u0011\u0013iA!\u0003\u0002\n\u0003\u0011.\u0001$B\t\u0005\t\u0001AY!F\u0001\u0019\rU!\u0011BA\u0005\u0002I\u0017AR!G\u0007\t\u000e5M\u0011BA\u0005\u0002I\u0017I!!C\u0001\u0019\u0004a9\u0011kA\u0001\u0005\u0010A\u001b\t\u0001VB\u0003"}, strings={"findOriginalTopMostOverriddenDescriptors", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/Set;", "OverridingUtilsKt", "findTopMostOverriddenDescriptors", "", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "selectMostSpecificInEachOverridableGroup", "", "H", "", "descriptorByHandle", "Lkotlin/Function1;", "Lkotlin/Extension;"}, moduleName="kotlin-compiler")
public final class OverridingUtilsKt {
    @NotNull
    public static final <D extends CallableDescriptor> List<D> findTopMostOverriddenDescriptors(D $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List list = (List)DFS.dfs((Collection)CollectionsKt.listOf($receiver), findTopMostOverriddenDescriptors.1.INSTANCE, new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<D>>(new ArrayList()){

            public void afterChildren(@NotNull CallableDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if (current.getOverriddenDescriptors().isEmpty()) {
                    CallableDescriptor callableDescriptor = current;
                    if (callableDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    ((ArrayList)this.result).add(callableDescriptor);
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(list, "DFS.dfs(\n            lis\u2026         }\n            })");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableDescriptor> Set<D> findOriginalTopMostOverriddenDescriptors(D $receiver) {
        void var2_2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable iterable = OverridingUtilsKt.findTopMostOverriddenDescriptors($receiver);
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            CallableDescriptor callableDescriptor;
            void it;
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)item$iv;
            Collection collection = destination$iv;
            if (it.getOriginal() == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            collection.add(callableDescriptor);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <H> Collection<H> selectMostSpecificInEachOverridableGroup(Collection<? extends H> $receiver, @NotNull Function1<? super H, ? extends CallableDescriptor> descriptorByHandle) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptorByHandle, "descriptorByHandle");
        if ($receiver.size() <= 1) {
            return $receiver;
        }
        LinkedList<? extends H> queue = new LinkedList<H>($receiver);
        SmartSet<Object> result2 = SmartSet.Companion.create();
        while (CollectionsKt.isNotEmpty((Collection)queue)) {
            void $receiver$iv;
            SmartSet conflictedHandles;
            Object nextHandle = CollectionsKt.first((List)queue);
            Collection<H> overridableGroup2 = OverridingUtil.extractMembersOverridableInBothWays(nextHandle, (Collection)queue, descriptorByHandle, new Function1<H, Unit>(conflictedHandles = SmartSet.Companion.create()){
                final /* synthetic */ SmartSet $conflictedHandles;

                public final void invoke(H it) {
                    H h = it;
                    Intrinsics.checkExpressionValueIsNotNull(h, "it");
                    this.$conflictedHandles.add(h);
                }
                {
                    this.$conflictedHandles = smartSet;
                    super(1);
                }
            });
            if (overridableGroup2.size() == 1 && overridableGroup2.isEmpty()) {
                Object t = CollectionsKt.single((Iterable)overridableGroup2);
                Intrinsics.checkExpressionValueIsNotNull(t, "overridableGroup.single()");
                result2.add(t);
                continue;
            }
            H mostSpecific = OverridingUtil.selectMostSpecificMember(overridableGroup2, descriptorByHandle);
            CallableDescriptor mostSpecificDescriptor = descriptorByHandle.invoke(mostSpecific);
            Iterable iterable = overridableGroup2;
            for (Object element$iv : $receiver$iv) {
                Object it = element$iv;
                if (OverridingUtil.isMoreSpecific(mostSpecificDescriptor, descriptorByHandle.invoke(it))) continue;
                ((Collection)conflictedHandles).add(element$iv);
            }
            if (CollectionsKt.isNotEmpty(conflictedHandles)) {
                result2.addAll(conflictedHandles);
            }
            H h = mostSpecific;
            Intrinsics.checkExpressionValueIsNotNull(h, "mostSpecific");
            result2.add(h);
        }
        return result2;
    }
}

