/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.types.BoundsSubstitutor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t%\u0015\tA\"A\u0003\u0001\u000b\u0005AA!B\u0001\u0005\u0003\u0015\t\u0001bD\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!A!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001bB\u0003\u0001\u0019\u0001\u0001b#\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u0002+\t!\t\u0001c\u0001\u001a\u0003a\u0011Q\u0014\u0001\f\"2\u0011\t\u0011B\u0002E\u0003\u001b\u0011I!!C\u0001\u001d\u0001a\u0019\u0011\"\u0003E\u0004\u001b\u001dI!!C\u0001\u001d\u0002%\u0011\u0011\"\u0001M\u00051\u0011I1\u0001C\u0003\u000e\u0003a-\u0011kA\u0001\t\r\u0015B\u0001BE\u0007\u0003\u0019\u0003A*#G\u0002\t'5\t\u0001\u0014DS\u000f\u0011Oi!\u0001$\u0001\u0019&e\u0019\u0001\u0002F\u0007\u00029\u0003I2\u0001C\n\u000e\u0003ae\u0011kA\u0001\t*\u0015\"Aa\u0003\u0005\u0016\u001b\u0005AZ#K\u0007\u0005\u0007\"Ai!\u0004\u0003\n\u0005%\tA\u0014\u0001\r\b9\r\n6aA\u0007\u0003\t\u001fA\u0001\"\u000b\u0006\u0005\u0007\"A\t\"D\u0001\u0019\fq\u0019\u0013kA\u0002\u000e\u0005\u0011I\u00012C\u0015\u000e\t\u0005C\u0001rA\u0007\b\u0013\tI\u0011\u0001(\u0001\n\u0005%\t\u0001\u0014\u0002\r\u0005#\u000e\tQ\u0001A\u0015\u000b\t\rC\u0001BC\u0007\u00021+a2%U\u0002\u0004\u001b\t!1\u0002c\u0006*\u0015\u0011\u0019\u0005\u0002\u0003\u0007\u000e\u0003ae\u0011k\u0001\u0003\u0006\u00015\u0011A\u0001\u0004\u0005\u000eS)!1\t\u0003\u0005\u0006\u001b\u0005AZ!U\u0002\u0005\u000b\u0001i!\u0001b\u0007\t\u0014%jAa\u0011\u0005\t\u00065!\u0011BA\u0005\u00029\u0001A2!U\u0002\u0005\u000b\u0001i!\u0001\u0002\b\t\u001e%RAa\u0011\u0005\t\u001f5\tA\u0004\u0001\u000f$#\u000e\u0019QB\u0001C\u0010\u0011AI\u001b\u0002B!\t\u0011Ci9\u0001G\tR\u0007\u0005!\u0019#U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/results/CandidateCallWithArgumentMapping;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "K", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "argumentsToParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parametersWithDefaultValuesCount", "", "(Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;Ljava/util/Map;I)V", "argumentKeys", "", "getArgumentKeys", "()Ljava/util/Collection;", "argumentsCount", "getArgumentsCount", "()I", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getCallElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "isGeneric", "", "()Z", "getParametersWithDefaultValuesCount", "getResolvedCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "resultingDescriptor", "getResultingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "upperBoundsSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "Lorg/jetbrains/annotations/NotNull;", "getExtensionReceiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "substituteUpperBounds", "getValueParameterType", "argumentKey", "(Ljava/lang/Object;Z)Lorg/jetbrains/kotlin/types/KotlinType;", "toString", "", "Companion"}, moduleName="kotlin-compiler")
public final class CandidateCallWithArgumentMapping<D extends CallableDescriptor, K> {
    private final boolean isGeneric;
    private final TypeSubstitutor upperBoundsSubstitutor;
    @NotNull
    private final MutableResolvedCall<D> resolvedCall;
    private final Map<K, ValueParameterDescriptor> argumentsToParameters;
    private final int parametersWithDefaultValuesCount;
    public static final Companion Companion = org.jetbrains.kotlin.resolve.calls.results.CandidateCallWithArgumentMapping$Companion.INSTANCE;

    @NotNull
    public String toString() {
        return this.resolvedCall.getCall() + ": " + this.parametersWithDefaultValuesCount + " defaults in " + this.resolvedCall.getCandidateDescriptor();
    }

    @NotNull
    public final D getResultingDescriptor() {
        Object d = this.resolvedCall.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "resolvedCall.resultingDescriptor");
        return d;
    }

    public final int getArgumentsCount() {
        return this.argumentsToParameters.size();
    }

    @NotNull
    public final Collection<K> getArgumentKeys() {
        return this.argumentsToParameters.keySet();
    }

    @NotNull
    public final KtElement getCallElement() {
        KtElement ktElement = this.resolvedCall.getCall().getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
        return ktElement;
    }

    public final boolean isGeneric() {
        return this.isGeneric;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KotlinType getExtensionReceiverType(boolean substituteUpperBounds) {
        KotlinType kotlinType;
        Annotated annotated = this.getResultingDescriptor().getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            void var3_3;
            Annotated $receiver$iv = annotated;
            KotlinType extensionReceiverType = (KotlinType)$receiver$iv;
            kotlinType = (KotlinType)(substituteUpperBounds ? this.upperBoundsSubstitutor.substitute(extensionReceiverType, Variance.INVARIANT) : var3_3);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @Nullable
    public final KotlinType getValueParameterType(K argumentKey, boolean substituteUpperBounds) {
        KotlinType kotlinType;
        ValueParameterDescriptor valueParameterDescriptor = this.argumentsToParameters.get(argumentKey);
        if (valueParameterDescriptor != null) {
            ValueParameterDescriptor $receiver$iv = valueParameterDescriptor;
            ValueParameterDescriptor valueParameterDescriptor2 = $receiver$iv;
            KotlinType kotlinType2 = valueParameterDescriptor2.getVarargElementType();
            if (kotlinType2 == null) {
                KotlinType kotlinType3 = valueParameterDescriptor2.getType();
                kotlinType2 = kotlinType3;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "valueParameterDescriptor.type");
            }
            KotlinType valueParameterType = kotlinType2;
            kotlinType = substituteUpperBounds ? this.upperBoundsSubstitutor.substitute(valueParameterType, Variance.INVARIANT) : valueParameterType;
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @NotNull
    public final MutableResolvedCall<D> getResolvedCall() {
        return this.resolvedCall;
    }

    public final int getParametersWithDefaultValuesCount() {
        return this.parametersWithDefaultValuesCount;
    }

    private CandidateCallWithArgumentMapping(MutableResolvedCall<D> resolvedCall, Map<K, ? extends ValueParameterDescriptor> argumentsToParameters, int parametersWithDefaultValuesCount) {
        this.resolvedCall = resolvedCall;
        this.argumentsToParameters = argumentsToParameters;
        this.parametersWithDefaultValuesCount = parametersWithDefaultValuesCount;
        this.isGeneric = CollectionsKt.isNotEmpty((Collection)this.resolvedCall.getResultingDescriptor().getOriginal().getTypeParameters());
        this.upperBoundsSubstitutor = BoundsSubstitutor.createUpperBoundsSubstitutor(this.resolvedCall.getResultingDescriptor());
    }

    public /* synthetic */ CandidateCallWithArgumentMapping(@NotNull MutableResolvedCall resolvedCall, @NotNull Map argumentsToParameters, int parametersWithDefaultValuesCount, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall, argumentsToParameters, parametersWithDefaultValuesCount);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!yAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K\u0015B\u0019!D\u0004\n\u0005%\tAUA\u0005\u0003\u0013\u0005!3\u0001\u0007\u0002\u0012\t\u0011\t\u0001RA\u000b\u00021\u000f\t\"\u0001b\u0001\t\u0007e1\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001*\u0002\u0019\nea\u0001\"B\u0007\u000b\u0013\tI\u0011\u0001\u0007\u0004\n\u000b%!\u0011BA\u0005\u0002I\rAj\u0001g\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/results/CandidateCallWithArgumentMapping$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/calls/results/CandidateCallWithArgumentMapping;", "D", "K", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "resolvedArgumentToKeys", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", ""}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <D extends CallableDescriptor, K> CandidateCallWithArgumentMapping<D, K> create(@NotNull MutableResolvedCall<D> call, @NotNull Function1<? super ResolvedValueArgument, ? extends Collection<? extends K>> resolvedArgumentToKeys) {
            Intrinsics.checkParameterIsNotNull(call, "call");
            Intrinsics.checkParameterIsNotNull(resolvedArgumentToKeys, "resolvedArgumentToKeys");
            HashMap argumentsToParameters = MapsKt.hashMapOf(new Pair[0]);
            int parametersWithDefaultValuesCount = 0;
            Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = call.getValueArguments().entrySet().iterator();
            while (iterator2.hasNext()) {
                void $receiver$iv;
                void $receiver$iv2;
                Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
                Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)$receiver$iv2.getKey();
                Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> $i$f$component1 = entry;
                ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)$receiver$iv.getValue();
                if (resolvedValueArgument instanceof DefaultValueArgument) {
                    ++parametersWithDefaultValuesCount;
                    continue;
                }
                ResolvedValueArgument resolvedValueArgument2 = resolvedValueArgument;
                Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument2, "resolvedValueArgument");
                Collection<K> keys = resolvedArgumentToKeys.invoke(resolvedValueArgument2);
                for (K argumentKey : keys) {
                    Map map2 = argumentsToParameters;
                    ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameterDescriptor");
                    MapsKt.set(map2, argumentKey, valueParameterDescriptor2);
                }
            }
            return new CandidateCallWithArgumentMapping(call, argumentsToParameters, parametersWithDefaultValuesCount, null);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

