/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptNameUtil;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0011\u0019\u0017\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\t\t-A1!D\u0001\u0019\u0005e\u0019\u0001rA\u0007\u00021\u0011)3\u0002B\u0006\t\n5!\u0011BA\u0005\u00021\u0017AR!G\u0002\t\r5\t\u0001TB\u0013\t\t-Aq!D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#I\u001b\u0002B!\t\u0011\u0007i9\u0001\u0007\u0002R\u0007\u0005!)!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/script/StandardScriptDefinition;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "()V", "ARGS_NAME", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getScriptName", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptParameters", "", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "isScript", "", "file", "Lcom/intellij/psi/PsiFile;"}, moduleName="kotlin-compiler")
public final class StandardScriptDefinition
implements KotlinScriptDefinition {
    private static final Name ARGS_NAME;
    public static final StandardScriptDefinition INSTANCE;
    public static final StandardScriptDefinition INSTANCE$;

    @Override
    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull(script, "script");
        Name name = ScriptNameUtil.fileNameWithExtensionStripped(script, ".kts");
        Intrinsics.checkExpressionValueIsNotNull(name, "ScriptNameUtil.fileNameW\u2026efinition.STD_SCRIPT_EXT)");
        return name;
    }

    @Override
    public boolean isScript(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return Intrinsics.areEqual(PathUtil.getFileExtension(file.getName()), "kts");
    }

    @Override
    @NotNull
    public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(scriptDescriptor);
        KotlinType arrayOfStrings = builtIns.getArrayType(Variance.INVARIANT, builtIns.getStringType());
        Name name = ARGS_NAME;
        Intrinsics.checkExpressionValueIsNotNull(name, "ARGS_NAME");
        KotlinType kotlinType = arrayOfStrings;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "arrayOfStrings");
        return CollectionsKt.listOf(new ScriptParameter(name, kotlinType));
    }

    private StandardScriptDefinition() {
        INSTANCE = this;
        INSTANCE$ = this;
        ARGS_NAME = Name.identifier("args");
    }

    static {
        new StandardScriptDefinition();
    }
}

