/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0011\u0011\u001d\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/jvm/ClassMapperLite;", "", "()V", "mapClass", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;"}, moduleName="kotlin-compiler")
public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;
    public static final ClassMapperLite INSTANCE$;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        ClassId javaClassId;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String internalName = StringsKt.replace$default(classId.asString(), '.', '$', false, 4);
        String simpleName = StringsKt.removePrefix(internalName, (CharSequence)"kotlin/");
        if (Intrinsics.areEqual(simpleName, internalName) ^ true) {
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            for (int i = 0; i < jvmPrimitiveTypeArray.length; ++i) {
                JvmPrimitiveType jvmPrimitive = jvmPrimitiveTypeArray[i];
                PrimitiveType primitiveType = jvmPrimitive.getPrimitiveType();
                if (Intrinsics.areEqual(simpleName, primitiveType.getTypeName().asString())) {
                    String string = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull(string, "jvmPrimitive.desc");
                    return string;
                }
                if (!Intrinsics.areEqual(simpleName, primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual(simpleName, KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        if ((javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe())) != null) {
            return "L" + StringsKt.replace$default(javaClassId.asString(), '.', '$', false, 4) + ";";
        }
        return "L" + internalName + ";";
    }

    private ClassMapperLite() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new ClassMapperLite();
    }
}

