/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.PerformanceCounter;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001E\t\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ!\u0001C\u0002\t\u0001a\u0001\u0001\u0005\u0006\u001a\u0003a\u0005Q$a\u0005\u000bCCI1\u0001C\u0001\u000e\u0003a\r\u0011\"\u0003\u0005\u0003\u001b\u0015I1\u0001\"\u0001\n\u0003a\u0005\u0001TA\t\u00021\u0003\t6!\u0001\u0005\u0004KC!!\u0002c\u0003\u000e\u0003\u00112\u0011C\u0001\u0003\u0001\u0011\u0019Ib\u0001#\u0004\u000e\t%\u0011\u0011\"\u0001\u0013\u00071\u001d\t6!\u0001E\bK\rA\u0001\"D\u0001\u0019\u0012\u0015\u001a\u0001\"C\u0007\u00021#I#\u0002B!\t\u0011\u000fi\u0011\u0001\u0007\u0003\u001dCE\u001b1!\u0004\u0002\u0005\n!)\u0001"}, strings={"Lorg/jetbrains/kotlin/util/CounterWithExclude;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "name", "", "excludedCounters", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)V", "callStack", "Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "getCallStack", "()Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "countTime", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enterExcludedMethod", "", "exitExcludedMethod", "CallStackWithTime", "Companion"}, moduleName="kotlin-compiler")
public final class CounterWithExclude
extends PerformanceCounter {
    private static final ThreadLocal<Map<CounterWithExclude, CallStackWithTime>> counterToCallStackMapThreadLocal;
    public static final Companion Companion;

    private final CallStackWithTime getCallStack() {
        return CounterWithExclude.Companion.getCallStack(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T countTime(@NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        this.incrementTime(this.getCallStack().push(true));
        try {
            T t = block.invoke();
            return t;
        }
        finally {
            this.incrementTime(this.getCallStack().pop(true));
        }
    }

    public final void enterExcludedMethod() {
        this.incrementTime(this.getCallStack().push(false));
    }

    public final void exitExcludedMethod() {
        this.incrementTime(this.getCallStack().pop(false));
    }

    public CounterWithExclude(@NotNull String name, PerformanceCounter ... excludedCounters) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(excludedCounters, "excludedCounters");
        super(name);
        Object[] $receiver$iv = excludedCounters;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            PerformanceCounter it = (PerformanceCounter)element$iv;
            it.getExcludedFrom$kotlin_compiler().add(this);
        }
    }

    static {
        Companion = org.jetbrains.kotlin.util.CounterWithExclude$Companion.INSTANCE;
        counterToCallStackMapThreadLocal = new ThreadLocal();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001#\u0003\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005A\u0011!B\u0001\r\u0003\u0015\tAq\u0001\u0003\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&(\u0011\t\u0001\u0002B\u0007\u00021\u000fIj\u0002#\u0003\u000e\u001a%)\u0011\u0002B\u0005\u0003\u0013\u0005A*\u0001\u0007\u0002\n\u0005%\t\u00014\u0002\r\u0006#\u000e\tAAB\u0013\u0004\u0011\u001bi\u0011\u0001'\u0002&\u000f!9Q\"\u0001M\u00043\rAy!D\u0001\u0019\u0006\u0015:\u0001\u0002C\u0007\u00021\u000fI2\u0001c\u0004\u000e\u0003a\u0015QU\u0004E\t\u001b\u0015\u0001\u0012\"\u0006\u0002\r\u0002a\u0015\u0001TA\u000b\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005E\u001b\u0011\u0001c\u0005*\u0015\u0011\t\u0005\u0002c\u0001\u000e\t%\u0011\u0011\"\u0001M\u00031\t\t6!A\u0003\u0001S\u001d!\u0011\t\b\u0005\u0004\u001b\u0005A:!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "", "()V", "callStack", "Ljava/util/Stack;", "", "intervalStartTime", "", "intervalUsefulTime", "callStackUpdate", "Lkotlin/Function1;", "", "Lkotlin/Extension;", "isEnteredCounter", "pop", "usefulCall", "push", "peekOrFalse", "kotlin.jvm.PlatformType", "(Ljava/util/Stack;)Ljava/lang/Boolean;"}, moduleName="kotlin-compiler")
    private static final class CallStackWithTime {
        private final Stack<Boolean> callStack = new Stack();
        private long intervalStartTime;

        public final Boolean peekOrFalse(Stack<Boolean> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            return $receiver.isEmpty() ? Boolean.valueOf(false) : $receiver.peek();
        }

        private final long intervalUsefulTime(Function1<? super Stack<Boolean>, Unit> callStackUpdate) {
            long delta = this.peekOrFalse(this.callStack) != false ? PerformanceCounter.Companion.currentTime() - this.intervalStartTime : 0L;
            callStackUpdate.invoke(this.callStack);
            this.intervalStartTime = PerformanceCounter.Companion.currentTime();
            return delta;
        }

        public final long push(boolean usefulCall) {
            if (!this.isEnteredCounter() && !usefulCall) {
                return 0L;
            }
            return this.intervalUsefulTime((Function1<? super Stack<Boolean>, Unit>)new Function1<Stack<Boolean>, Unit>(usefulCall){
                final /* synthetic */ boolean $usefulCall;

                public final void invoke(Stack<Boolean> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    $receiver.push(this.$usefulCall);
                }
                {
                    this.$usefulCall = bl;
                    super(1);
                }
            });
        }

        public final long pop(boolean usefulCall) {
            if (!this.isEnteredCounter()) {
                return 0L;
            }
            PreconditionsKt.assert(Intrinsics.areEqual(this.callStack.peek(), usefulCall));
            return this.intervalUsefulTime(pop.1.INSTANCE);
        }

        public final boolean isEnteredCounter() {
            return !this.callStack.isEmpty();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001E\u0013\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAA\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0002B\u0001\t\u000b5\t\u0001tA\r\u0004\u0011\u0017i\u0011\u0001G\u0002*)\u0011\t\u0005\u0002c\u0001\u000e\u0015%A\u0011bB\u0005\u0003\u0013\u0005A2!\u0003\u0002\n\u0003a\u001d\u0001T\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!A\u0001#\u0003"}, strings={"Lorg/jetbrains/kotlin/util/CounterWithExclude$Companion;", "", "()V", "counterToCallStackMapThreadLocal", "Ljava/lang/ThreadLocal;", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "getCounterToCallStackMapThreadLocal", "()Ljava/lang/ThreadLocal;", "getCallStack", "counter"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final ThreadLocal<Map<CounterWithExclude, CallStackWithTime>> getCounterToCallStackMapThreadLocal() {
            return counterToCallStackMapThreadLocal;
        }

        /*
         * WARNING - void declaration
         */
        private final CallStackWithTime getCallStack(CounterWithExclude counter) {
            CallStackWithTime callStackWithTime;
            PerformanceCounter.Companion companion = PerformanceCounter.Companion;
            ThreadLocal<Map<CounterWithExclude, CallStackWithTime>> threadLocal$iv = this.getCounterToCallStackMapThreadLocal();
            Map<CounterWithExclude, CallStackWithTime> value$iv = threadLocal$iv.get();
            if (value$iv == null) {
                value$iv = new HashMap<CounterWithExclude, CallStackWithTime>();
                threadLocal$iv.set(value$iv);
            }
            Map<CounterWithExclude, CallStackWithTime> $receiver$iv = value$iv;
            CallStackWithTime value$iv2 = $receiver$iv.get(counter);
            if (value$iv2 == null) {
                CallStackWithTime answer$iv = new CallStackWithTime();
                $receiver$iv.put(counter, answer$iv);
                callStackWithTime = answer$iv;
            } else {
                void var3_3;
                callStackWithTime = var3_3;
            }
            return callStackWithTime;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

