/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.collectionUtils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0005\u0010\u000b\u0005!1!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011QR\u0007\u0005\u0001\u001b\u0011I!!C\u0001%\u0003a\u0005\u0011C\u0001\u0003\u0001\u0011\u0005Ir\u0001c\u0001\u000e\u000b%\u0011\u0011\"\u0001\u0013\u0002\u0019\u0003A\n!G\u0004\t\u00055)\u0011BA\u0005\u0002I\u0005a\t\u0001'\u0001U\u0007\u000bi9\u0005B\"\u0011\u0011\ri!\u0001$\u0001%\u0003E\u0011A\u0001\u0001E\u0004#\u0011!\t\u0001C\u0001\u0016\u0003a!\u0011D\u0002E\u0005\u001b\u0011I!!C\u0001%\ba)\u0011D\u0003E\u0006\u001b!I!!C\u0001%\b%\u0019\u0011B\u0001G\u0001I\u0005Ab!U\u0002\u0002\u0011\u001b!6QA\u0007$\t\r\u0003\u0002bB\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0002E\u0011A\u0001\u0001E\u0004#\t!\t\u0001C\u0001\u001a\r!%Q\u0002B\u0005\u0003\u0013\u0005!;\u0001G\u0003\u001a\u0019!-QBC\u0005\u0003\u0013\u0005!;!C\u0003\n\t%\u0011\u0011\"\u0001\u0013\u00021\u0003Ab\u0001VB\u0003\u001biAy!D\u0003\n\u0005%\tA%\u0001G\u00011\u0003\t\"\u0001\u0002\u0001\t\u0003U)\u0011BA\u0005\u0002I\u0005a\t\u0001'\u0001\u001a\u0010!AQ\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001'\u0001Q\u0007\u0003!6Q\u0001"}, strings={"concatInOrder", "", "T", "c1", "c2", "ScopeUtilsKt", "getFirstMatch", "Scope", "", "scopes", "", "callback", "Lkotlin/Function1;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getFromAllScopes", "concat", "collection"}, moduleName="kotlin-compiler")
public final class ScopeUtilsKt {
    @Nullable
    public static final <T> Collection<T> concat(Collection<? extends T> $receiver, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkParameterIsNotNull(collection, "collection");
        if (collection.isEmpty()) {
            return $receiver;
        }
        if ($receiver == null) {
            return collection;
        }
        if ($receiver instanceof LinkedHashSet) {
            ((LinkedHashSet)$receiver).addAll(collection);
            return $receiver;
        }
        LinkedHashSet<T> result2 = new LinkedHashSet<T>($receiver);
        result2.addAll(collection);
        return result2;
    }

    @NotNull
    public static final <T> Collection<T> concatInOrder(@Nullable Collection<? extends T> c1, @Nullable Collection<? extends T> c2) {
        Collection result2;
        Collection collection;
        Collection collection2;
        if (c1 == null || c1.isEmpty()) {
            collection2 = c2;
        } else if (c2 == null || c2.isEmpty()) {
            collection2 = c1;
        } else {
            LinkedHashSet<T> result3 = new LinkedHashSet<T>();
            result3.addAll(c1);
            result3.addAll(c2);
            collection2 = result3;
        }
        if ((collection = (result2 = collection2)) == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(@NotNull List<? extends Scope> scopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        if (scopes.isEmpty()) {
            return SetsKt.emptySet();
        }
        Collection<T> result2 = null;
        for (Scope scope2 : scopes) {
            result2 = ScopeUtilsKt.concat(result2, callback.invoke(scope2));
        }
        Collection<T> collection = result2;
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @Nullable
    public static final <Scope, T> T getFirstMatch(@NotNull List<? extends Scope> scopes, @NotNull Function1<? super Scope, ? extends T> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        for (Scope scope2 : scopes) {
            T result2 = callback.invoke(scope2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

