/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ExpressionReplacingVisitorSupport;
import org.gradle.internal.SystemProperties;
import org.gradle.model.dsl.internal.inputs.RuleInputAccess;
import org.gradle.model.dsl.internal.inputs.RuleInputAccessBacking;
import org.gradle.model.dsl.internal.transform.InputReferences;
import org.gradle.model.dsl.internal.transform.RuleMetadata;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.internal.core.ModelPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class RuleVisitor
extends ExpressionReplacingVisitorSupport {
    public static final String INVALID_ARGUMENT_LIST = "argument list must be exactly 1 literal non empty string";
    private static final String AST_NODE_METADATA_INPUTS_KEY = RuleVisitor.class.getName() + ".inputs";
    public static final String AST_NODE_METADATA_LOCATION_KEY = RuleVisitor.class.getName() + ".location";
    private static final String DOLLAR = "$";
    private static final String INPUT = "input";
    private static final String HAS = "has";
    private static final ClassNode ANNOTATION_CLASS_NODE = new ClassNode(RuleMetadata.class);
    private static final ClassNode CONTEXTUAL_INPUT_TYPE = new ClassNode(RuleInputAccessBacking.class);
    private static final ClassNode ACCESS_API_TYPE = new ClassNode(RuleInputAccess.class);
    private static final String GET_ACCESS = "getAccess";
    private static final String ACCESS_HOLDER_FIELD = "_" + RuleInputAccess.class.getName().replace(".", "_");
    private final SourceUnit sourceUnit;
    private InputReferences inputs;
    private VariableExpression accessVariable;

    public RuleVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public static void visitGeneratedClosure(ClassNode node) {
        MethodNode method = AstUtils.getGeneratedClosureImplMethod((ClassNode)node);
        Statement closureCode = method.getCode();
        SourceLocation sourceLocation = (SourceLocation)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_LOCATION_KEY);
        if (sourceLocation != null) {
            AnnotationNode metadataAnnotation = new AnnotationNode(ANNOTATION_CLASS_NODE);
            metadataAnnotation.addMember("scriptSourceDescription", (Expression)new ConstantExpression((Object)sourceLocation.getScriptSourceDescription()));
            metadataAnnotation.addMember("lineNumber", (Expression)new ConstantExpression((Object)sourceLocation.getLineNumber()));
            metadataAnnotation.addMember("columnNumber", (Expression)new ConstantExpression((Object)sourceLocation.getColumnNumber()));
            InputReferences inputs = (InputReferences)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY);
            if (!inputs.isEmpty()) {
                metadataAnnotation.addMember("absoluteInputPaths", (Expression)new ListExpression(RuleVisitor.constants(inputs.getAbsolutePaths())));
                metadataAnnotation.addMember("absoluteInputLineNumbers", (Expression)new ListExpression(RuleVisitor.constants(inputs.getAbsolutePathLineNumbers())));
                metadataAnnotation.addMember("relativeInputPaths", (Expression)new ListExpression(RuleVisitor.constants(inputs.getRelativePaths())));
                metadataAnnotation.addMember("relativeInputLineNumbers", (Expression)new ListExpression(RuleVisitor.constants(inputs.getRelativePathLineNumbers())));
            }
            node.addAnnotation(metadataAnnotation);
        }
    }

    private static List<Expression> constants(Collection<?> values) {
        ArrayList expressions = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value : values) {
            expressions.add(new ConstantExpression(value));
        }
        return expressions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClosureExpression(ClosureExpression expression) {
        if (this.inputs == null) {
            this.inputs = new InputReferences();
            try {
                this.accessVariable = new VariableExpression(ACCESS_HOLDER_FIELD, ACCESS_API_TYPE);
                super.visitClosureExpression(expression);
                BlockStatement code = (BlockStatement)expression.getCode();
                code.setNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY, (Object)this.inputs);
                this.accessVariable.setClosureSharedVariable(true);
                StaticMethodCallExpression getAccessCall = new StaticMethodCallExpression(CONTEXTUAL_INPUT_TYPE, GET_ACCESS, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                DeclarationExpression variableDeclaration = new DeclarationExpression(this.accessVariable, new Token(100, "=", -1, -1), (Expression)getAccessCall);
                code.getStatements().add(0, new ExpressionStatement((Expression)variableDeclaration));
                code.getVariableScope().putDeclaredVariable((Variable)this.accessVariable);
            }
            finally {
                this.inputs = null;
            }
        } else {
            expression.getVariableScope().putReferencedLocalVariable((Variable)this.accessVariable);
            super.visitClosureExpression(expression);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        String methodName = call.getMethodAsString();
        if (call.isImplicitThis() && methodName != null && methodName.equals(DOLLAR)) {
            this.visitInputMethod(call);
        } else {
            super.visitMethodCallExpression(call);
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        if (expression.getLeftExpression() instanceof VariableExpression) {
            expression.setRightExpression(this.replaceExpr(expression.getRightExpression()));
        } else {
            super.visitBinaryExpression(expression);
        }
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        ArrayList names = Lists.newArrayList();
        boolean propertyNameIsPart = this.extractPropertyPath((Expression)expression, names);
        if (names.isEmpty() || !((String)names.get(0)).equals("thing")) {
            super.visitPropertyExpression(expression);
        } else {
            String modelPath = ModelPath.pathString((Iterable)names);
            this.inputs.relativePath(modelPath, expression.getLineNumber());
            if (propertyNameIsPart) {
                this.replaceVisitedExpressionWith((Expression)this.conditionalInputGet(modelPath, (Expression)expression));
            } else {
                expression.setObjectExpression((Expression)this.conditionalInputGet(modelPath, expression.getObjectExpression()));
            }
        }
    }

    private TernaryExpression conditionalInputGet(String modelPath, Expression originalExpression) {
        return new TernaryExpression(new BooleanExpression((Expression)new MethodCallExpression((Expression)this.accessVariable, HAS, (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)modelPath)))), (Expression)new MethodCallExpression((Expression)this.accessVariable, INPUT, (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)modelPath))), originalExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean extractPropertyPath(Expression expression, List<String> names) {
        if (expression instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)expression;
            if (!this.extractPropertyPath(propertyExpression.getObjectExpression(), names)) return true;
            return this.extractPropertyPath(propertyExpression.getProperty(), names);
        }
        if (expression instanceof VariableExpression) {
            names.add(((VariableExpression)expression).getName());
            return true;
        } else {
            if (!(expression instanceof ConstantExpression)) return false;
            ConstantExpression constantExpression = (ConstantExpression)expression;
            if (!constantExpression.getType().equals((Object)ClassHelper.STRING_TYPE)) return false;
            names.add(constantExpression.getText());
        }
        return true;
    }

    public void visitVariableExpression(VariableExpression expression) {
        if (expression.isThisExpression() || expression.isSuperExpression()) {
            super.visitVariableExpression(expression);
        } else {
            String modelPath = expression.getText();
            if (modelPath.equals("thing")) {
                this.inputs.relativePath(modelPath, expression.getLineNumber());
                this.replaceVisitedExpressionWith((Expression)this.conditionalInputGet(modelPath, (Expression)expression));
            } else {
                super.visitVariableExpression(expression);
            }
        }
    }

    private void visitInputMethod(MethodCallExpression call) {
        ConstantExpression argExpression = AstUtils.hasSingleConstantStringArg((MethodCallExpression)call);
        if (argExpression == null) {
            this.error((ASTNode)call, INVALID_ARGUMENT_LIST);
        } else {
            String modelPath = argExpression.getText();
            if (modelPath.isEmpty()) {
                this.error((ASTNode)argExpression, INVALID_ARGUMENT_LIST);
                return;
            }
            try {
                ModelPath.validatePath((String)modelPath);
            }
            catch (ModelPath.InvalidPathException e) {
                String message = "Invalid model path given as rule input." + SystemProperties.getInstance().getLineSeparator() + "  > " + e.getMessage();
                if (e.getCause() != null) {
                    message = message + SystemProperties.getInstance().getLineSeparator() + "    > " + e.getCause().getMessage();
                }
                this.error((ASTNode)argExpression, message);
                return;
            }
            this.inputs.absolutePath(modelPath, call.getLineNumber());
            call.setObjectExpression((Expression)new VariableExpression((Variable)this.accessVariable));
            call.setMethod((Expression)new ConstantExpression((Object)INPUT));
        }
    }

    private void error(ASTNode call, String message) {
        SyntaxException syntaxException = new SyntaxException(message, call.getLineNumber(), call.getColumnNumber());
        this.sourceUnit.getErrorCollector().addError(syntaxException, this.sourceUnit);
    }
}

