/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!5Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001A\u0002A\r\u00021\u0003\tk\"C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004#\u000e\t\u0001\u0002B\u0013\u0005\t-Ai!D\u0001\u0019\u000f\u0015RAA\u0003E\b\u001b\u0005Ab!G\u0003\t\u00115\u0019\u0001\u0014C\u0015\u00021%)c\u0002\u0002\u0006\t\u00145\t\u0001DC\r\u0006\u0011!i1\u0001'\u0005*\u0003aI\u0011d\u0001E\u000b\u001b\u0005A\u001a!\n\u0005\u0005\u0003!YQ\"\u0001\r\b3\rA9\"D\u0001\u0019\u0019\u0015\"AA\u0003E\r\u001b\u0005AR\"\n\u0003\u0005\u0017!mQ\"\u0001\r\u000fK)!1\u0002#\b\u000e\u0003a9\u0011$\u0002\u0005\t\u001b\rA\n\"K\u0001\u0019\u0013%:A!\u0011\u0005\t\n5\t\u0001$B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0019Q\"\u0001M\u0004#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S\u001d!\u0011\t\bE\u0006\u001b\u0005Ab!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeFenceMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "fenceStart", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Ljava/lang/String;)V", "endLineRegex", "Lkotlin/text/Regex;", "realInterestingOffset", "", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "endsThisFence", "line", "", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class CodeFenceMarkerBlock
extends MarkerBlockImpl {
    private final Regex endLineRegex;
    private int realInterestingOffset;
    private final ProductionHolder productionHolder;
    private final String fenceStart;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        int nextLineOffset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffset() < this.realInterestingOffset) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        if (!nextLineConstraints.extendsPrev(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.realInterestingOffset = nextLineOffset = pos.getNextLineOrEofOffset();
        CharSequence currentLine = nextLineConstraints.eatItselfFromString(pos.getCurrentLine());
        if (this.endsThisFence(currentLine)) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), MarkdownTokenTypes.Companion.getCODE_FENCE_END())));
            this.scheduleProcessingResult(nextLineOffset, MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        } else {
            IntRange contentRange = new IntRange(Math.min(pos.getOffset() + 1 + this.getConstraints().getCharsEaten(pos.getCurrentLine()), nextLineOffset), nextLineOffset);
            if (((Number)contentRange.getStart()).intValue() < ((Number)contentRange.getEndInclusive()).intValue()) {
                this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(contentRange, MarkdownTokenTypes.Companion.getCODE_FENCE_CONTENT())));
            }
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    private final boolean endsThisFence(CharSequence line) {
        return this.endLineRegex.matches(line);
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getCODE_FENCE();
    }

    public CodeFenceMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull String fenceStart) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)fenceStart, (String)"fenceStart");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.fenceStart = fenceStart;
        this.endLineRegex = new Regex("^ {0,3}" + this.fenceStart + "+ *" + "$");
        this.realInterestingOffset = -1;
    }
}

