/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.IntRange;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeFenceMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q\u0001\u0001\u0007\u0001!/IB!\u0003\u0002\n\u0003a\t\u0001\u0014AO\u0001\u0018\u0005\u0016\u0011kA\u0001\t\u0004\u0015*Ba\u0003\u0005\u0003\u001b\u0011I!!C\u0001\u0019\u0007a\u0015\u0011$\u0002E\u0004\u001b\rAB!K\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a\tQ\u0005\u0007\u0003\u0002\u0011\u001bi\u0011\u0001G\u0004\u001a\u000b!\u001dQb\u0001\r\u0005S\u0005AJ!G\u0005\t\u001059\u0011BA\u0005\u00021#I!!C\u0001\u0019\u0012aA\u0011d\u0001\u0005\u0006\u001b\u0005AZ!J\u000b\u0005\u0003!IQ\u0002C\u0005\u0003\u0013\u0005A\n\"\u0003\u0002\n\u0003aEA\u0012\u0001\r\t3\u0015A9!D\u0002\u0019\t%\n\u0001\u0014B\r\u0004\u0011'i\u0011\u0001\u0007\u0006&\u001d\u0011Y\u0001RC\u0007\u00021-IR\u0001c\u0002\u000e\u0007a!\u0011&\u0001M\u00053\rA\u0019\"D\u0001\u0019\u0015\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "createNodesForFenceStart", "", "fenceAndInfo", "Lkotlin/Pair;", "", "getFenceStartAndInfo", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "interruptsParagraph", "", "Companion"}, moduleName="intellij-markdown")
public final class CodeFenceProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Regex REGEX;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        Pair<String, String> fenceAndInfo = this.getFenceStartAndInfo(pos, stateInfo.getCurrentConstraints());
        if (fenceAndInfo != null) {
            this.createNodesForFenceStart(pos, fenceAndInfo, productionHolder);
            return CollectionsKt.listOf((Object)new CodeFenceMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (String)fenceAndInfo.getFirst()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.getFenceStartAndInfo(pos, constraints) != null;
    }

    private final void createNodesForFenceStart(LookaheadText.Position pos, Pair<String, String> fenceAndInfo, ProductionHolder productionHolder) {
        int infoStartPosition = pos.getNextLineOrEofOffset() - ((String)fenceAndInfo.getSecond()).length();
        productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset(), infoStartPosition), MarkdownTokenTypes.Companion.getCODE_FENCE_START())));
        if (((String)fenceAndInfo.getSecond()).length() > 0) {
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(infoStartPosition, pos.getNextLineOrEofOffset()), MarkdownTokenTypes.Companion.getFENCE_LANG())));
        }
    }

    private final Pair<String, String> getFenceStartAndInfo(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)Companion.getREGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        String string = matchGroup != null ? matchGroup.getValue() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MatchGroup matchGroup2 = matchResult2.getGroups().get(2);
        String string2 = matchGroup2 != null ? matchGroup2.getValue() : null;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return new Pair((Object)string, (Object)string2);
    }

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.CodeFenceProvider$Companion.INSTANCE;
        REGEX = new Regex("^ {0,3}(~~~+|```+)([^`]*)$");
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

