/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class EnterInPropertiesFileHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterInPropertiesFileHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterInPropertiesFileHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/codeInsight/editorActions/enter/EnterInPropertiesFileHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/EnterInPropertiesFileHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/EnterInPropertiesFileHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (file instanceof PropertiesFile) {
            EnterInPropertiesFileHandler.handleEnterInPropertiesFile(editor, editor.getDocument(), psiAtOffset, caretOffset);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static void handleEnterInPropertiesFile(Editor editor, Document document, PsiElement psiAtOffset, int caretOffset) {
        String toInsert;
        String text = document.getText();
        String line = text.substring(0, caretOffset);
        int i = line.lastIndexOf(10);
        if (i > 0) {
            line = line.substring(i);
        }
        if (PropertiesUtil.isUnescapedBackSlashAtTheEnd(line)) {
            toInsert = "\n  ";
        } else {
            IElementType elementType;
            IElementType iElementType = elementType = psiAtOffset == null ? null : psiAtOffset.getNode().getElementType();
            toInsert = elementType == PropertiesTokenTypes.VALUE_CHARACTERS ? "\\\n  " : (elementType == PropertiesTokenTypes.END_OF_LINE_COMMENT && "#!".indexOf(document.getText().charAt(caretOffset)) == -1 ? "\n#" : "\n");
        }
        document.insertString(caretOffset, (CharSequence)toInsert);
        editor.getCaretModel().moveToOffset(caretOffset += toInsert.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }
}

