/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@State(name="IgnoredPropertiesFilesSuffixesManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/resourceBundles.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class IgnoredPropertiesFilesSuffixesManager
implements PersistentStateComponent<IgnoredPropertiesFilesSuffixesState>,
Disposable {
    private IgnoredPropertiesFilesSuffixesState myState = new IgnoredPropertiesFilesSuffixesState();
    private final List<SuffixesListener> myListeners = new ArrayList<SuffixesListener>();

    public IgnoredPropertiesFilesSuffixesManager(Project project) {
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public static IgnoredPropertiesFilesSuffixesManager getInstance(Project project) {
        return (IgnoredPropertiesFilesSuffixesManager)ServiceManager.getService((Project)project, IgnoredPropertiesFilesSuffixesManager.class);
    }

    public void addListener(SuffixesListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(SuffixesListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isPropertyComplete(ResourceBundle resourceBundle, String key) {
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            if (propertiesFile.findPropertyByKey(key) != null || this.myState.getIgnoredSuffixes().contains(PropertiesUtil.getSuffix(propertiesFile))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getIgnoredSuffixes() {
        return this.myState.getIgnoredSuffixes();
    }

    public List<PropertiesFile> getPropertiesFilesWithoutTranslation(ResourceBundle resourceBundle, final Set<String> keys) {
        final PropertiesFile defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile();
        return ContainerUtil.filter(resourceBundle.getPropertiesFiles(), (Condition)new Condition<PropertiesFile>(){

            public boolean value(PropertiesFile propertiesFile) {
                if (defaultPropertiesFile.equals(propertiesFile)) {
                    return false;
                }
                for (String key : keys) {
                    if (propertiesFile.findPropertyByKey(key) != null || IgnoredPropertiesFilesSuffixesManager.this.myState.getIgnoredSuffixes().contains(PropertiesUtil.getSuffix(propertiesFile))) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public void addSuffixes(Collection<String> suffixes) {
        HashSet oldSuffixes = new HashSet(this.myState.getIgnoredSuffixes());
        this.myState.addSuffixes(suffixes);
        Set<String> newSuffixes = this.myState.getIgnoredSuffixes();
        if (!oldSuffixes.equals(newSuffixes)) {
            for (SuffixesListener listener : this.myListeners) {
                listener.suffixesChanged();
            }
        }
    }

    public void setSuffixes(Collection<String> suffixes) {
        Set<String> oldSuffixes = this.myState.getIgnoredSuffixes();
        this.myState.setSuffixes(suffixes);
        if (!oldSuffixes.equals(suffixes)) {
            for (SuffixesListener listener : this.myListeners) {
                listener.suffixesChanged();
            }
        }
    }

    @Nullable
    public IgnoredPropertiesFilesSuffixesState getState() {
        return this.myState.isEmpty() ? null : this.myState;
    }

    public void loadState(IgnoredPropertiesFilesSuffixesState state) {
        this.myState = state;
    }

    public void dispose() {
        if (!this.myListeners.isEmpty()) {
            this.myListeners.clear();
        }
    }

    public static interface SuffixesListener {
        public void suffixesChanged();
    }

    public static class IgnoredPropertiesFilesSuffixesState {
        @Property(surroundWithTag=false)
        @AbstractCollection(elementTag="ignored-suffix", surroundWithTag=false)
        public Set<String> myIgnoredSuffixes = new HashSet();

        public void addSuffixes(Collection<String> suffixes) {
            this.myIgnoredSuffixes.addAll(suffixes);
        }

        public void setSuffixes(Collection<String> suffixes) {
            this.myIgnoredSuffixes = new HashSet(suffixes);
        }

        public Set<String> getIgnoredSuffixes() {
            return this.myIgnoredSuffixes;
        }

        public boolean isEmpty() {
            return this.myIgnoredSuffixes.isEmpty();
        }
    }
}

