/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib.vectordrawable;

import com.android.annotations.Nullable;
import com.android.assetstudiolib.vectordrawable.VdParser;
import com.android.assetstudiolib.vectordrawable.VdTree;
import com.google.common.base.Charsets;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;

public class VdPreview {
    @Nullable
    public static BufferedImage getPreviewFromVectorXml(int imageWidth, @Nullable String xmlFileContent, @Nullable StringBuilder vdErrorLog) {
        if (xmlFileContent == null || xmlFileContent.isEmpty()) {
            return null;
        }
        VdParser p = new VdParser();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlFileContent.getBytes(Charsets.UTF_8));
        VdTree vdTree = p.parse(inputStream, vdErrorLog);
        if (vdTree == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(imageWidth, (int)((float)imageWidth / vdTree.getAspectRatio()), 2);
        Graphics g = image.getGraphics();
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        vdTree.draw(g, image.getWidth(), image.getHeight());
        return image;
    }
}

