/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chartlib;

import com.android.annotations.concurrency.GuardedBy;
import com.android.tools.chartlib.CircularArrayList;
import java.util.List;

public class TimelineData {
    private final int myStreams;
    @GuardedBy(value="this")
    private final List<Sample> mSamples;
    @GuardedBy(value="this")
    private long mStart;
    @GuardedBy(value="this")
    private float mMaxTotal;

    public TimelineData(int streams, int capacity) {
        this.myStreams = streams;
        this.mSamples = new CircularArrayList<Sample>(capacity);
        this.clear();
    }

    public synchronized long getStartTime() {
        return this.mStart;
    }

    public int getStreamCount() {
        return this.myStreams;
    }

    public synchronized float getMaxTotal() {
        return this.mMaxTotal;
    }

    public synchronized void add(long time, int type, float ... values) {
        assert (values.length == this.myStreams);
        float total = 0.0f;
        for (float value : values) {
            total += value;
        }
        this.mMaxTotal = Math.max(this.mMaxTotal, total);
        this.mSamples.add(new Sample((float)(time - this.mStart) / 1000.0f, type, values));
    }

    public synchronized void clear() {
        this.mSamples.clear();
        this.mMaxTotal = 0.0f;
        this.mStart = System.currentTimeMillis();
    }

    public int size() {
        return this.mSamples.size();
    }

    public Sample get(int index) {
        return this.mSamples.get(index);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized float getEndTime() {
        return (this.mSamples.isEmpty() ? 0.0f : (float)(System.currentTimeMillis() - this.mStart)) / 1000.0f;
    }

    public static class Sample {
        public final float time;
        public final float[] values;
        public final int type;

        public Sample(float time, int type, float[] values) {
            this.time = time;
            this.values = values;
            this.type = type;
        }
    }
}

