/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import com.android.tools.perflib.heap.io.HprofBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class ArrayInstance
extends Instance {
    private final Type mType;
    private final int mLength;
    private final long mValuesOffset;

    public ArrayInstance(long id, @NonNull StackTrace stack, @NonNull Type type, int length, long valuesOffset) {
        super(id, stack);
        this.mType = type;
        this.mLength = length;
        this.mValuesOffset = valuesOffset;
    }

    @NonNull
    public Object[] getValues() {
        Object[] values = new Object[this.mLength];
        this.getBuffer().setPosition(this.mValuesOffset);
        for (int i = 0; i < this.mLength; ++i) {
            values[i] = this.readValue(this.mType);
        }
        return values;
    }

    @NonNull
    private byte[] asRawByteArray(int start, int elementCount) {
        this.getBuffer().setPosition(this.mValuesOffset);
        assert (this.mType != Type.OBJECT);
        assert (start + elementCount <= this.mLength);
        byte[] bytes = new byte[elementCount * this.mType.getSize()];
        this.getBuffer().readSubSequence(bytes, start * this.mType.getSize(), elementCount * this.mType.getSize());
        return bytes;
    }

    @NonNull
    public char[] asCharArray(int offset, int length) {
        assert (this.mType == Type.CHAR);
        CharBuffer charBuffer = ByteBuffer.wrap(this.asRawByteArray(offset, length)).order(HprofBuffer.HPROF_BYTE_ORDER).asCharBuffer();
        char[] result = new char[length];
        charBuffer.get(result);
        return result;
    }

    @Override
    public final int getSize() {
        return this.mLength * this.mHeap.mSnapshot.getTypeSize(this.mType);
    }

    @Override
    public final void accept(@NonNull Visitor visitor) {
        visitor.visitArrayInstance(this);
        if (this.mType == Type.OBJECT) {
            for (Object value : this.getValues()) {
                if (!(value instanceof Instance)) continue;
                if (!this.mReferencesAdded) {
                    ((Instance)value).addReference(this);
                }
                visitor.visitLater(this, (Instance)value);
            }
            this.mReferencesAdded = true;
        }
    }

    @Override
    public ClassObj getClassObj() {
        if (this.mType == Type.OBJECT) {
            return super.getClassObj();
        }
        return this.mHeap.mSnapshot.findClass(Type.getClassNameOfPrimitiveArray(this.mType));
    }

    public Type getArrayType() {
        return this.mType;
    }

    public final String toString() {
        String className = this.getClassObj().getClassName();
        if (className.endsWith("[]")) {
            className = className.substring(0, className.length() - 2);
        }
        return String.format("%s[%d]@%d (0x%x)", className, this.mLength, this.getUniqueId(), this.getUniqueId());
    }
}

