/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.property;

import hidden.org.apache.jackrabbit.webdav.DavConstants;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertyName;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.XmlSerializable;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PropContainer
implements XmlSerializable,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(PropContainer.class);

    public abstract boolean addContent(Object var1);

    public abstract boolean isEmpty();

    public abstract int getContentSize();

    public abstract Collection getContent();

    public abstract boolean contains(DavPropertyName var1);

    public Element toXml(Document document) {
        Element prop = DomUtil.createElement(document, "prop", NAMESPACE);
        Iterator it = this.getContent().iterator();
        while (it.hasNext()) {
            Object content = it.next();
            if (content instanceof XmlSerializable) {
                prop.appendChild(((XmlSerializable)content).toXml(document));
                continue;
            }
            log.debug("Unexpected content in PropContainer: should be XmlSerializable.");
        }
        return prop;
    }
}

