/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelViews {
    public static <T> ModelView<T> assertType(ModelView<?> untypedView, ModelType<T> type) {
        if (type.isAssignableFrom(untypedView.getType())) {
            ModelView<?> view = untypedView;
            return view;
        }
        throw new IllegalArgumentException("Model view of type " + untypedView.getType() + " requested as " + type);
    }

    public static <T> ModelView<T> assertType(ModelView<?> untypedView, ModelReference<T> reference) {
        return ModelViews.assertType(untypedView, reference.getType());
    }

    public static <T> T getInstance(ModelView<?> untypedView, ModelReference<T> reference) {
        return ModelViews.assertType(untypedView, reference.getType()).getInstance();
    }

    public static <T> T getInstance(ModelView<?> untypedView, ModelType<T> type) {
        return ModelViews.assertType(untypedView, type).getInstance();
    }

    public static <T> T getInstance(ModelView<?> untypedView, Class<T> type) {
        return ModelViews.assertType(untypedView, ModelType.of(type)).getInstance();
    }
}

