/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestRunnerUtils;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class TestClassGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    public TestClassGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        PsiClass testClass = JUnitUtil.getTestClass((Location)location);
        if (testClass == null) {
            return false;
        }
        sourceElement.set((Object)testClass);
        if (context.getModule() == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(context.getModule().getOptionValue("external.linked.project.path"));
        configuration.getSettings().setTaskNames(TEST_SOURCE_SET_TASKS);
        configuration.getSettings().setScriptParameters(String.format("--tests %s", testClass.getQualifiedName()));
        configuration.setName(testClass.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location<PsiMethod> methodLocation = TestRunnerUtils.getMethodLocation(contextLocation);
        if (methodLocation != null) {
            return false;
        }
        PsiClass testClass = JUnitUtil.getTestClass((Location)location);
        if (testClass == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.linked.project.path"), (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!configuration.getSettings().getTaskNames().containsAll(TEST_SOURCE_SET_TASKS)) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        return scriptParameters.contains(String.format("--tests %s ", testClass.getQualifiedName()));
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, Runnable performRunnable) {
        PsiClass psiClass = (PsiClass)fromContext.getSourceElement();
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestClassGradleConfigurationProducer.applyTestConfiguration(configuration, context, (PsiClass[])ArrayUtil.toObjectArray(classes, PsiClass.class))) {
                    return;
                }
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestClassGradleConfigurationProducer.applyTestConfiguration(configuration, context, new PsiClass[]{aClass})) {
                    return;
                }
                super.runForClass(aClass, psiMethod, context, performRunnable);
            }
        };
        if (inheritorChooser.runMethodInAbstractClass(context, performRunnable, null, (PsiClass)fromContext.getSourceElement())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    private static boolean applyTestConfiguration(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, PsiClass ... containingClasses) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/gradle/execution/test/runner/TestClassGradleConfigurationProducer", "applyTestConfiguration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/execution/test/runner/TestClassGradleConfigurationProducer", "applyTestConfiguration"));
        }
        if (containingClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClasses", "org/jetbrains/plugins/gradle/execution/test/runner/TestClassGradleConfigurationProducer", "applyTestConfiguration"));
        }
        if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(context.getModule().getOptionValue("external.linked.project.path"));
        configuration.getSettings().setTaskNames(TEST_SOURCE_SET_TASKS);
        StringBuilder buf = new StringBuilder();
        for (PsiClass aClass : containingClasses) {
            buf.append(String.format("--tests %s ", aClass.getQualifiedName()));
        }
        configuration.getSettings().setScriptParameters(buf.toString());
        configuration.setName(StringUtil.join((Object[])containingClasses, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass aClass) {
                return aClass.getName();
            }
        }, (String)"|"));
        return true;
    }
}

