/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlXpathHelper {
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    private Document xmlDocument;

    public XmlXpathHelper(String xml, boolean namespaceAware) throws XmlParserException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            InputSource is = new InputSource(new StringReader(xml));
            factory.setNamespaceAware(namespaceAware);
            factory.setValidating(false);
            this.xmlDocument = factory.newDocumentBuilder().parse(is);
        }
        catch (Exception ex) {
            throw new XmlParserException(ex);
        }
    }

    public XmlXpathHelper(String xml) throws XmlParserException {
        this(xml, false);
    }

    public String queryXml(String xpathExpr) throws XmlParserException {
        try {
            return this.xmlDocument == null ? "" : this.xpath.evaluate(xpathExpr, this.xmlDocument);
        }
        catch (XPathExpressionException ex) {
            throw new XmlParserException(ex);
        }
    }

    public String getValue(Node node, String expr) throws XmlParserException {
        try {
            return this.xpath.compile(expr).evaluate(node);
        }
        catch (XPathExpressionException ex) {
            throw new XmlParserException(ex);
        }
    }

    public static class XmlParserException
    extends Exception {
        public XmlParserException(Throwable cause) {
            super(cause);
        }

        public XmlParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public XmlParserException(String message) {
            super(message);
        }
    }
}

