/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.ExportToHTMLManager;
import com.intellij.codeEditor.printing.FileSeparatorProvider;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class HTMLTextPainter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeEditor.printing.HTMLTextPainter");
    private int myOffset = 0;
    private final EditorHighlighter myHighlighter;
    private final String myText;
    private final String myFileName;
    private final String myHTMLFileName;
    private int mySegmentEnd;
    private final PsiFile myPsiFile;
    private final Document myDocument;
    private int lineCount;
    private int myFirstLineNumber;
    private final boolean myPrintLineNumbers;
    private int myColumn;
    private final LineMarkerInfo[] myMethodSeparators;
    private int myCurrentMethodSeparator;
    private final Project myProject;
    private final Map<TextAttributes, String> myStyleMap = new HashMap<TextAttributes, String>();
    private final Map<Color, String> mySeparatorStyles = new HashMap<Color, String>();

    public HTMLTextPainter(PsiFile psiFile, Project project, String dirName, boolean printLineNumbers) {
        List<LineMarkerInfo> separators;
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myPrintLineNumbers = printLineNumbers;
        this.myHighlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)psiFile.getVirtualFile());
        this.myText = psiFile.getText();
        this.myHighlighter.setText((CharSequence)this.myText);
        this.mySegmentEnd = this.myText.length();
        this.myFileName = psiFile.getVirtualFile().getPresentableUrl();
        this.myHTMLFileName = dirName + File.separator + ExportToHTMLManager.getHTMLFileName(psiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        this.myDocument = psiDocumentManager.getDocument(psiFile);
        ArrayList<LineMarkerInfo> methodSeparators = new ArrayList<LineMarkerInfo>();
        if (this.myDocument != null && (separators = FileSeparatorProvider.getFileSeparators(psiFile, this.myDocument)) != null) {
            methodSeparators.addAll(separators);
        }
        this.myMethodSeparators = methodSeparators.toArray(new LineMarkerInfo[methodSeparators.size()]);
        this.myCurrentMethodSeparator = 0;
    }

    public void setSegment(int segmentStart, int segmentEnd, int firstLineNumber) {
        this.myOffset = segmentStart;
        this.mySegmentEnd = segmentEnd;
        this.myFirstLineNumber = firstLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(TreeMap refMap, FileType fileType) throws FileNotFoundException {
        HighlighterIterator hIterator = this.myHighlighter.createIterator(this.myOffset);
        if (hIterator.atEnd()) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.myHTMLFileName), CharsetToolkit.UTF8_CHARSET);
        this.lineCount = this.myFirstLineNumber;
        TextAttributes prevAttributes = null;
        Iterator refKeys = null;
        int refOffset = -1;
        PsiReference ref = null;
        if (refMap != null && (refKeys = refMap.keySet().iterator()).hasNext()) {
            Integer key = (Integer)refKeys.next();
            ref = (PsiReference)refMap.get(key);
            refOffset = key;
        }
        int referenceEnd = -1;
        try {
            this.writeHeader(writer, new File(this.myFileName).getName());
            if (this.myFirstLineNumber == 0) {
                this.writeLineNumber(writer);
            }
            String closeTag = null;
            this.getMethodSeparator(hIterator.getStart());
            while (!hIterator.atEnd()) {
                TextAttributes textAttributes = hIterator.getTextAttributes();
                int hStart = hIterator.getStart();
                int hEnd = hIterator.getEnd();
                if (hEnd > this.mySegmentEnd) break;
                boolean haveNonWhiteSpace = false;
                for (int offset = hStart; offset < hEnd; ++offset) {
                    char c = this.myText.charAt(offset);
                    if (c == ' ' || c == '\t') continue;
                    haveNonWhiteSpace = true;
                    break;
                }
                if (!haveNonWhiteSpace) {
                    this.writeString(writer, this.myText, hStart, hEnd - hStart, fileType);
                    hIterator.advance();
                    continue;
                }
                if (refOffset > 0 && hStart <= refOffset && hEnd > refOffset) {
                    referenceEnd = this.writeReferenceTag(writer, ref);
                }
                if (!HTMLTextPainter.equals(prevAttributes, textAttributes) && referenceEnd < 0) {
                    if (closeTag != null) {
                        writer.write(closeTag);
                    }
                    closeTag = this.writeFontTag(writer, textAttributes);
                    prevAttributes = textAttributes;
                }
                this.writeString(writer, this.myText, hStart, hEnd - hStart, fileType);
                if (referenceEnd > 0 && hEnd >= referenceEnd) {
                    writer.write("</a>");
                    referenceEnd = -1;
                    if (refKeys.hasNext()) {
                        Integer key = (Integer)refKeys.next();
                        ref = (PsiReference)refMap.get(key);
                        refOffset = key;
                    }
                }
                hIterator.advance();
            }
            if (closeTag != null) {
                writer.write(closeTag);
            }
            HTMLTextPainter.writeFooter(writer);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private LineMarkerInfo getMethodSeparator(int offset) {
        LineMarkerInfo tmpMarker;
        if (this.myDocument == null) {
            return null;
        }
        int line = this.myDocument.getLineNumber(Math.max(0, Math.min(this.myDocument.getTextLength(), offset)));
        LineMarkerInfo marker = null;
        while (this.myCurrentMethodSeparator < this.myMethodSeparators.length && (tmpMarker = this.myMethodSeparators[this.myCurrentMethodSeparator]) != null && FileSeparatorProvider.getDisplayLine(tmpMarker, this.myDocument) <= line) {
            marker = tmpMarker;
            ++this.myCurrentMethodSeparator;
        }
        return marker;
    }

    private int writeReferenceTag(Writer writer, PsiReference ref) throws IOException {
        PsiElement refClass = ref.resolve();
        PsiFile refFile = refClass.getContainingFile();
        String refPackageName = PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(refFile.getContainingDirectory(), false);
        String psiPackageName = PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(this.myPsiFile.getContainingDirectory(), false);
        StringBuffer fileName = new StringBuffer();
        if (!psiPackageName.equals(refPackageName)) {
            StringTokenizer tokens = new StringTokenizer(psiPackageName, ".");
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                fileName.append("../");
            }
            StringTokenizer refTokens = new StringTokenizer(refPackageName, ".");
            while (refTokens.hasMoreTokens()) {
                String token = refTokens.nextToken();
                fileName.append(token);
                fileName.append('/');
            }
        }
        fileName.append(ExportToHTMLManager.getHTMLFileName(refFile));
        writer.write("<a href=\"" + fileName + "\">");
        return ref.getElement().getTextRange().getEndOffset();
    }

    private String writeFontTag(Writer writer, TextAttributes textAttributes) throws IOException {
        writer.write("<span class=\"" + this.myStyleMap.get(textAttributes) + "\">");
        return "</span>";
    }

    private void writeString(Writer writer, CharSequence charArray, int start, int length, FileType fileType) throws IOException {
        for (int i = start; i < start + length; ++i) {
            char c = charArray.charAt(i);
            if (c == '<') {
                this.writeChar(writer, "&lt;");
                continue;
            }
            if (c == '>') {
                this.writeChar(writer, "&gt;");
                continue;
            }
            if (c == '&') {
                this.writeChar(writer, "&amp;");
                continue;
            }
            if (c == '\"') {
                this.writeChar(writer, "&quot;");
                continue;
            }
            if (c == '\t') {
                int tabSize = CodeStyleSettingsManager.getSettings((Project)this.myProject).getTabSize(fileType);
                if (tabSize <= 0) {
                    tabSize = 1;
                }
                int nSpaces = tabSize - this.myColumn % tabSize;
                for (int j = 0; j < nSpaces; ++j) {
                    this.writeChar(writer, " ");
                }
                continue;
            }
            if (c == '\n' || c == '\r') {
                boolean writeSlashR = false;
                if (c == '\r' && i + 1 < start + length && charArray.charAt(i + 1) == '\n') {
                    writeSlashR = true;
                    ++i;
                } else if (c == '\n') {
                    this.writeChar(writer, " ");
                }
                LineMarkerInfo marker = this.getMethodSeparator(i + 1);
                if (marker != null) {
                    Color color = marker.separatorColor;
                    writer.write("<hr class=\"" + this.mySeparatorStyles.get(color) + "\">");
                } else {
                    if (writeSlashR) {
                        this.writeChar(writer, "\r");
                    }
                    writer.write(10);
                }
                this.writeLineNumber(writer);
                continue;
            }
            this.writeChar(writer, String.valueOf(c));
        }
    }

    private void writeChar(Writer writer, String s) throws IOException {
        writer.write(s);
        ++this.myColumn;
    }

    private void writeLineNumber(@NonNls Writer writer) throws IOException {
        this.myColumn = 0;
        ++this.lineCount;
        if (this.myPrintLineNumbers) {
            writer.write("<a name=\"l" + this.lineCount + "\">");
            writer.write("<span class=\"ln\">");
            String s = Integer.toString(this.lineCount);
            writer.write(s);
            int extraSpaces = 4 - s.length();
            do {
                writer.write(32);
            } while (extraSpaces-- > 0);
            writer.write("</span></a>");
        }
    }

    private void writeHeader(@NonNls Writer writer, String title) throws IOException {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        writer.write("<html>\r\n");
        writer.write("<head>\r\n");
        writer.write("<title>" + title + "</title>\r\n");
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n");
        this.writeStyles(writer);
        writer.write("</head>\r\n");
        Color color = scheme.getDefaultBackground();
        if (color == null) {
            color = JBColor.GRAY;
        }
        writer.write("<BODY BGCOLOR=\"#" + Integer.toString(color.getRGB() & 0xFFFFFF, 16) + "\">\r\n");
        writer.write("<TABLE CELLSPACING=0 CELLPADDING=5 COLS=1 WIDTH=\"100%\" BGCOLOR=\"#C0C0C0\" >\r\n");
        writer.write("<TR><TD><CENTER>\r\n");
        writer.write("<FONT FACE=\"Arial, Helvetica\" COLOR=\"#000000\">\r\n");
        writer.write(title + "</FONT>\r\n");
        writer.write("</center></TD></TR></TABLE>\r\n");
        writer.write("<pre>\r\n");
    }

    private void writeStyles(@NonNls Writer writer) throws IOException {
        writer.write("<style type=\"text/css\">\n");
        writer.write(".ln { color: rgb(0,0,0); font-weight: normal; font-style: normal; }\n");
        HighlighterIterator hIterator = this.myHighlighter.createIterator(this.myOffset);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        while (!hIterator.atEnd()) {
            TextAttributes textAttributes = hIterator.getTextAttributes();
            if (!this.myStyleMap.containsKey(textAttributes)) {
                String styleName = "s" + this.myStyleMap.size();
                this.myStyleMap.put(textAttributes, styleName);
                writer.write("." + styleName + " { ");
                Color foreColor = textAttributes.getForegroundColor();
                if (foreColor == null) {
                    foreColor = scheme.getDefaultForeground();
                }
                writer.write("color: " + HTMLTextPainter.colorToHtml(foreColor) + "; ");
                if ((textAttributes.getFontType() & 1) != 0) {
                    writer.write("font-weight: bold; ");
                }
                if ((textAttributes.getFontType() & 2) != 0) {
                    writer.write("font-style: italic; ");
                }
                writer.write("}\n");
            }
            hIterator.advance();
        }
        for (LineMarkerInfo separator : this.myMethodSeparators) {
            Color color = separator.separatorColor;
            if (color == null || this.mySeparatorStyles.containsKey(color)) continue;
            String styleName = "ls" + this.mySeparatorStyles.size();
            this.mySeparatorStyles.put(color, styleName);
            String htmlColor = HTMLTextPainter.colorToHtml(color);
            writer.write("." + styleName + " { height: 1px; border-width: 0; color: " + htmlColor + "; background-color:" + htmlColor + "}\n");
        }
        writer.write("</style>\n");
    }

    private static String colorToHtml(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeEditor/printing/HTMLTextPainter", "colorToHtml"));
        }
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    private static void writeFooter(@NonNls Writer writer) throws IOException {
        writer.write("</pre>\r\n");
        writer.write("</body>\r\n");
        writer.write("</html>");
    }

    private static boolean equals(TextAttributes attributes1, TextAttributes attributes2) {
        if (attributes2 == null) {
            return attributes1 == null;
        }
        if (attributes1 == null) {
            return false;
        }
        if (!Comparing.equal((Object)attributes1.getForegroundColor(), (Object)attributes2.getForegroundColor())) {
            return false;
        }
        if (attributes1.getFontType() != attributes2.getFontType()) {
            return false;
        }
        if (!Comparing.equal((Object)attributes1.getBackgroundColor(), (Object)attributes2.getBackgroundColor())) {
            return false;
        }
        return Comparing.equal((Object)attributes1.getEffectColor(), (Object)attributes2.getEffectColor());
    }

    public String getHTMLFileName() {
        return this.myHTMLFileName;
    }
}

