/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCodeInsightAction
extends CodeInsightAction {
    private final boolean myLookForInjectedEditor;

    protected BaseCodeInsightAction() {
        this(true);
    }

    protected BaseCodeInsightAction(boolean lookForInjectedEditor) {
        this.myLookForInjectedEditor = lookForInjectedEditor;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/actions/BaseCodeInsightAction", "getEditor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/BaseCodeInsightAction", "getEditor"));
        }
        Editor editor = this.getBaseEditor(dataContext, project);
        if (!this.myLookForInjectedEditor) {
            return editor;
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/BaseCodeInsightAction", "getInjectedEditor"));
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor, true);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor, boolean commit) {
        PsiDocumentManager documentManager;
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/BaseCodeInsightAction", "getInjectedEditor"));
        }
        Editor injectedEditor = editor;
        if (editor != null && (psiFile = (documentManager = PsiDocumentManager.getInstance((Project)project)).getCachedPsiFile(editor.getDocument())) != null) {
            if (commit) {
                documentManager.commitAllDocuments();
            }
            injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
        }
        return injectedEditor;
    }

    @Nullable
    protected Editor getBaseEditor(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/actions/BaseCodeInsightAction", "getBaseEditor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/BaseCodeInsightAction", "getBaseEditor"));
        }
        return super.getEditor(dataContext, project);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        LookupEx activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null) {
            presentation.setEnabled(this.isValidForLookup());
        } else {
            super.update(event);
        }
    }

    protected boolean isValidForLookup() {
        return false;
    }
}

