/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiClassReferenceElement
extends LookupItem<Object>
implements TypedLookupItem {
    public static final ClassConditionKey<JavaPsiClassReferenceElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaPsiClassReferenceElement.class);
    private final Object myClass;
    private volatile Reference<PsiClass> myCache;
    private final String myQualifiedName;
    private String myForcedPresentableName;
    private String myPackageDisplayName;
    private PsiSubstitutor mySubstitutor = PsiSubstitutor.EMPTY;

    public JavaPsiClassReferenceElement(PsiClass psiClass) {
        super(psiClass.getName(), psiClass.getName());
        this.myQualifiedName = psiClass.getQualifiedName();
        PsiFile file2 = psiClass.getContainingFile();
        this.myClass = file2 == null || file2.getVirtualFile() == null || this.myQualifiedName == null ? psiClass : PsiAnchor.create((PsiElement)psiClass);
        this.setInsertHandler((InsertHandler)AllClassesGetter.TRY_SHORTENING);
        this.setTailType(TailType.NONE);
        this.myPackageDisplayName = PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass);
    }

    public String getForcedPresentableName() {
        return this.myForcedPresentableName;
    }

    @Override
    @Nullable
    public PsiType getType() {
        PsiClass psiClass = this.getObject();
        return JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, this.getSubstitutor());
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public JavaPsiClassReferenceElement setSubstitutor(PsiSubstitutor substitutor) {
        this.mySubstitutor = substitutor;
        return this;
    }

    @Override
    @NotNull
    public String getLookupString() {
        if (this.myForcedPresentableName != null) {
            String string = this.myForcedPresentableName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "getLookupString"));
            }
            return string;
        }
        String string = super.getLookupString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "getLookupString"));
        }
        return string;
    }

    @Override
    public Set<String> getAllLookupStrings() {
        if (this.myForcedPresentableName != null) {
            return Collections.singleton(this.myForcedPresentableName);
        }
        return super.getAllLookupStrings();
    }

    public void setForcedPresentableName(String forcedPresentableName) {
        this.myForcedPresentableName = forcedPresentableName;
    }

    @Override
    @NotNull
    public PsiClass getObject() {
        if (this.myClass instanceof PsiAnchor) {
            PsiClass psiClass = (PsiClass)SoftReference.dereference(this.myCache);
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                if (psiClass2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "getObject"));
                }
                return psiClass2;
            }
            PsiAnchor anchor = (PsiAnchor)this.myClass;
            PsiClass retrieve = (PsiClass)anchor.retrieve();
            if (retrieve == null) {
                throw new AssertionError((Object)(this.myQualifiedName + "; anchor=" + anchor + "; diagnostics=" + (anchor instanceof PsiAnchor.StubIndexReference ? ((PsiAnchor.StubIndexReference)anchor).diagnoseNull() : null)));
            }
            this.myCache = new WeakReference<PsiClass>(retrieve);
            PsiClass psiClass3 = retrieve;
            if (psiClass3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "getObject"));
            }
            return psiClass3;
        }
        PsiClass psiClass = (PsiClass)this.myClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "getObject"));
        }
        return psiClass;
    }

    public boolean isValid() {
        if (this.myClass instanceof PsiClass) {
            return ((PsiClass)this.myClass).isValid();
        }
        return ((PsiAnchor)this.myClass).retrieve() != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaPsiClassReferenceElement)) {
            return false;
        }
        JavaPsiClassReferenceElement that = (JavaPsiClassReferenceElement)o;
        if (this.myQualifiedName != null) {
            return this.myQualifiedName.equals(that.myQualifiedName);
        }
        return Comparing.equal((Object)this.myClass, (Object)that.myClass);
    }

    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public int hashCode() {
        String s = this.myQualifiedName;
        return s == null ? 239 : s.hashCode();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        JavaPsiClassReferenceElement.renderClassItem(presentation, (LookupElement)this, this.getObject(), false, " (" + this.myPackageDisplayName + ")", this.mySubstitutor);
    }

    public static void renderClassItem(LookupElementPresentation presentation, LookupElement item, PsiClass psiClass, boolean diamond, @NotNull String locationString, @NotNull PsiSubstitutor substitutor) {
        if (locationString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationString", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "renderClassItem"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "renderClassItem"));
        }
        if (!(psiClass instanceof PsiTypeParameter)) {
            presentation.setIcon(DefaultLookupItemRenderer.getRawIcon(item, presentation.isReal()));
        }
        boolean strikeout = JavaElementLookupRenderer.isToStrikeout(item);
        presentation.setItemText(JavaPsiClassReferenceElement.getName(psiClass, item, diamond, substitutor));
        presentation.setStrikeout(strikeout);
        String tailText = locationString;
        if (item instanceof PsiTypeLookupItem && (((PsiTypeLookupItem)item).isIndicateAnonymous() && (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) || ((PsiTypeLookupItem)item).isAddArrayInitializer())) {
            tailText = "{...}" + tailText;
        }
        if (substitutor == PsiSubstitutor.EMPTY && !diamond && psiClass.getTypeParameters().length > 0) {
            tailText = "<" + StringUtil.join((Object[])psiClass.getTypeParameters(), (Function)new Function<PsiTypeParameter, String>(){

                public String fun(PsiTypeParameter psiTypeParameter) {
                    return psiTypeParameter.getName();
                }
            }, (String)("," + (JavaPsiClassReferenceElement.showSpaceAfterComma(psiClass) ? " " : ""))) + ">" + tailText;
        }
        presentation.setTailText(tailText, true);
    }

    public String getLocationString() {
        return " (" + this.myPackageDisplayName + ")";
    }

    private static String getName(PsiClass psiClass, LookupElement item, boolean diamond, @NotNull PsiSubstitutor substitutor) {
        PsiTypeParameter[] params;
        String forced;
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "getName"));
        }
        if (item instanceof JavaPsiClassReferenceElement && (forced = ((JavaPsiClassReferenceElement)item).getForcedPresentableName()) != null) {
            return forced;
        }
        String name = PsiUtilCore.getName((PsiElement)psiClass);
        if (diamond) {
            return name + "<>";
        }
        if (substitutor != PsiSubstitutor.EMPTY && (params = psiClass.getTypeParameters()).length > 0) {
            return name + JavaPsiClassReferenceElement.formatTypeParameters(substitutor, params);
        }
        return StringUtil.notNullize((String)name);
    }

    @Nullable
    private static String formatTypeParameters(@NotNull PsiSubstitutor substitutor, PsiTypeParameter[] params) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/completion/JavaPsiClassReferenceElement", "formatTypeParameters"));
        }
        boolean space = JavaPsiClassReferenceElement.showSpaceAfterComma((PsiClass)params[0]);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            PsiType type = substitutor.substitute(param);
            if (type == null) {
                return "";
            }
            if (type instanceof PsiClassType && ((PsiClassType)type).getParameters().length > 0) {
                buffer.append(((PsiClassType)type).rawType().getPresentableText()).append("<...>");
            } else {
                buffer.append(type.getPresentableText());
            }
            if (i >= params.length - 1) continue;
            buffer.append(",");
            if (!space) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static boolean showSpaceAfterComma(PsiClass element) {
        return CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_AFTER_COMMA;
    }
}

