/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class LabelReferenceCompletion
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> LABEL_REFERENCE = PlatformPatterns.psiElement().afterLeaf(new String[]{"break", "continue"});

    LabelReferenceCompletion() {
    }

    static void processLabelReference(CompletionResultSet result2, PsiLabelReference ref) {
        for (String s : ref.getVariants()) {
            result2.addElement(TailTypeDecorator.withTail(LookupElementBuilder.create((String)s), TailType.SEMICOLON));
        }
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/LabelReferenceCompletion", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/LabelReferenceCompletion", "addCompletions"));
        }
        PsiReference ref = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        if (ref instanceof PsiLabelReference) {
            LabelReferenceCompletion.processLabelReference(result2, (PsiLabelReference)ref);
        }
    }
}

