/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAnnotationMethodFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + CreateAnnotationMethodFromUsageFix.class.getName()));
    private final SmartPsiElementPointer<PsiNameValuePair> myNameValuePair;

    public CreateAnnotationMethodFromUsageFix(@NotNull PsiNameValuePair valuePair) {
        if (valuePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePair", "com/intellij/codeInsight/daemon/impl/quickfix/CreateAnnotationMethodFromUsageFix", "<init>"));
        }
        this.myNameValuePair = SmartPointerManager.getInstance((Project)valuePair.getProject()).createSmartPsiElementPointer((PsiElement)valuePair);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiNameValuePair call = this.getNameValuePair();
        if (call == null || !call.isValid()) {
            return false;
        }
        String name = call.getName();
        if (name == null || !PsiNameHelper.getInstance((Project)call.getProject()).isIdentifier(name)) {
            return false;
        }
        if (CreateAnnotationMethodFromUsageFix.getAnnotationValueType(call.getValue()) == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("create.method.from.usage.text", name));
        return true;
    }

    @Override
    protected PsiElement getElement() {
        PsiNameValuePair call = this.getNameValuePair();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        if (targetClass == null) {
            return;
        }
        PsiNameValuePair nameValuePair = this.getNameValuePair();
        if (nameValuePair == null || this.isValidElement((PsiElement)nameValuePair)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)nameValuePair.getProject()).getElementFactory();
        String methodName = nameValuePair.getName();
        LOG.assertTrue(methodName != null);
        PsiMethod method = factory.createMethod(methodName, (PsiType)PsiType.VOID);
        method = (PsiMethod)targetClass.add((PsiElement)method);
        PsiCodeBlock body = method.getBody();
        assert (body != null);
        body.delete();
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)nameValuePair, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        PsiType type = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(nameValuePair.getValue());
        LOG.assertTrue(type != null);
        ExpectedTypeInfo[] expectedTypes = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfo(type, 1, type, TailType.NONE)};
        CreateMethodFromUsageFix.doCreate(targetClass, method, true, ContainerUtil.map2List((Object[])PsiExpression.EMPTY_ARRAY, (Function)Pair.createFunction(null)), CreateAnnotationMethodFromUsageFix.getTargetSubstitutor((PsiElement)nameValuePair), expectedTypes, context);
    }

    @Nullable
    private static PsiType getAnnotationValueType(PsiAnnotationMemberValue value) {
        PsiType type = null;
        if (value instanceof PsiExpression) {
            type = ((PsiExpression)value).getType();
        } else if (value instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value).getInitializers();
            PsiType currentType = null;
            for (PsiAnnotationMemberValue initializer : initializers) {
                if (initializer instanceof PsiArrayInitializerMemberValue) {
                    return null;
                }
                if (!(initializer instanceof PsiExpression)) {
                    return null;
                }
                PsiType psiType = ((PsiExpression)initializer).getType();
                if (psiType == null) continue;
                if (currentType == null) {
                    currentType = psiType;
                    continue;
                }
                if (TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)psiType)) continue;
                if (TypeConversionUtil.isAssignable((PsiType)psiType, (PsiType)currentType)) {
                    currentType = psiType;
                    continue;
                }
                return null;
            }
            if (currentType != null) {
                type = currentType.createArrayType();
            }
        }
        if (type != null && ((Boolean)type.accept((PsiTypeVisitor)AnnotationsHighlightUtil.AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return type;
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiReference reference = element.getReference();
        return reference != null && reference.resolve() != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateAnnotationMethodFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    protected PsiNameValuePair getNameValuePair() {
        return (PsiNameValuePair)this.myNameValuePair.getElement();
    }
}

