/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.ui.GenerateEqualsWizard;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GenerateEqualsHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateEqualsHandler");
    private PsiField[] myEqualsFields = null;
    private PsiField[] myHashCodeFields = null;
    private PsiField[] myNonNullFields = null;
    private static final PsiElementClassMember[] DUMMY_RESULT = new PsiElementClassMember[1];

    public GenerateEqualsHandler() {
        super("");
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project, Editor editor) {
        boolean hasNonStaticFields;
        boolean needHashCode;
        this.myEqualsFields = null;
        this.myHashCodeFields = null;
        this.myNonNullFields = PsiField.EMPTY_ARRAY;
        GlobalSearchScope scope = aClass.getResolveScope();
        final PsiMethod equalsMethod = GenerateEqualsHelper.findMethod(aClass, GenerateEqualsHelper.getEqualsSignature(project, scope));
        final PsiMethod hashCodeMethod = GenerateEqualsHelper.findMethod(aClass, GenerateEqualsHelper.getHashCodeSignature());
        boolean needEquals = equalsMethod == null;
        boolean bl = needHashCode = hashCodeMethod == null;
        if (!needEquals && !needHashCode) {
            String text;
            String string = text = aClass instanceof PsiAnonymousClass ? CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.warning.anonymous", (Object[])new Object[0]) : CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.warning", (Object[])new Object[]{aClass.getQualifiedName()});
            if (Messages.showYesNoDialog((Project)project, (String)text, (String)CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                if (!((Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        try {
                            equalsMethod.delete();
                            hashCodeMethod.delete();
                            return Boolean.TRUE;
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            return Boolean.FALSE;
                        }
                    }
                })).booleanValue()) {
                    return null;
                }
                needHashCode = true;
                needEquals = true;
            } else {
                return null;
            }
        }
        if (!(hasNonStaticFields = GenerateEqualsHandler.hasNonStaticFields(aClass))) {
            HintManager.getInstance().showErrorHint(editor, "No fields to include in equals/hashCode have been found");
            return null;
        }
        GenerateEqualsWizard wizard = new GenerateEqualsWizard(project, aClass, needEquals, needHashCode);
        if (!wizard.showAndGet()) {
            return null;
        }
        this.myEqualsFields = wizard.getEqualsFields();
        this.myHashCodeFields = wizard.getHashCodeFields();
        this.myNonNullFields = wizard.getNonNullFields();
        return DUMMY_RESULT;
    }

    private static boolean hasNonStaticFields(PsiClass aClass) {
        for (PsiField field : aClass.getFields()) {
            if (field.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasMembers(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/generation/GenerateEqualsHandler", "hasMembers"));
        }
        return GenerateEqualsHandler.hasNonStaticFields(aClass);
    }

    @Override
    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] originalMembers) throws IncorrectOperationException {
        Project project = aClass.getProject();
        boolean useInstanceofToCheckParameterType = CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER;
        boolean useAccessors = CodeInsightSettings.getInstance().USE_ACCESSORS_IN_EQUALS_HASHCODE;
        GenerateEqualsHelper helper = new GenerateEqualsHelper(project, aClass, this.myEqualsFields, this.myHashCodeFields, this.myNonNullFields, useInstanceofToCheckParameterType, useAccessors);
        List<PsiGenerationInfo<PsiMethod>> list = OverrideImplementUtil.convert2GenerationInfos(helper.generateMembers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateEqualsHandler", "generateMemberPrototypes"));
        }
        return list;
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        return null;
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) {
        return null;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.myEqualsFields = null;
        this.myHashCodeFields = null;
        this.myNonNullFields = null;
    }
}

