/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.actions.MultiCaretCodeInsightAction;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CommentByBlockCommentAction
extends MultiCaretCodeInsightAction
implements DumbAware {
    public CommentByBlockCommentAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    @NotNull
    protected MultiCaretCodeInsightActionHandler getHandler() {
        CommentByBlockCommentHandler commentByBlockCommentHandler = new CommentByBlockCommentHandler();
        if (commentByBlockCommentHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "getHandler"));
        }
        return commentByBlockCommentHandler;
    }

    @Override
    protected boolean isValidFor(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidFor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidFor"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidFor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidFor"));
        }
        FileType fileType = file2.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter() != null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getLanguage());
        if (commenter == null) {
            commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getViewProvider().getBaseLanguage());
        }
        if (commenter == null) {
            return false;
        }
        return commenter.getBlockCommentPrefix() != null && commenter.getBlockCommentSuffix() != null;
    }
}

