/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;

public class JavaReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(PsiElement element) {
        return element instanceof PsiVariable && !(element instanceof ImplicitVariable) || element instanceof PsiClass;
    }

    public boolean isDeclarationWriteAccess(PsiElement element) {
        if (element instanceof PsiVariable && ((PsiVariable)element).getInitializer() != null) {
            return true;
        }
        return element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement;
    }

    public ReadWriteAccessDetector.Access getReferenceAccess(PsiElement referencedElement, PsiReference reference) {
        return this.getExpressionAccess(reference.getElement());
    }

    public ReadWriteAccessDetector.Access getExpressionAccess(PsiElement expression) {
        PsiElement actualReferee;
        if (!(expression instanceof PsiExpression)) {
            return ReadWriteAccessDetector.Access.Read;
        }
        PsiExpression expr = (PsiExpression)expression;
        boolean readAccess = PsiUtil.isAccessedForReading((PsiExpression)expr);
        boolean writeAccess = PsiUtil.isAccessedForWriting((PsiExpression)expr);
        if (!writeAccess && expr instanceof PsiReferenceExpression && (actualReferee = ((PsiReferenceExpression)expr).resolve()) instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)actualReferee))) {
            writeAccess = true;
            readAccess = false;
        }
        if (writeAccess && readAccess) {
            return ReadWriteAccessDetector.Access.ReadWrite;
        }
        return writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
    }
}

