/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SplitDeclarationAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SplitDeclarationAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SplitDeclarationAction", "isAvailable"));
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiDeclarationStatement.class, PsiClass.class});
        if (context instanceof PsiDeclarationStatement) {
            return this.isAvailableOnDeclarationStatement((PsiDeclarationStatement)context, element);
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field != null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) == null && SplitDeclarationAction.isAvailableOnField(field)) {
            this.setText(CodeInsightBundle.message((String)"intention.split.declaration.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean isAvailableOnField(PsiField field) {
        PsiElement nextField;
        PsiTypeElement typeElement = field.getTypeElement();
        if (typeElement == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiField.class) != field) {
            return true;
        }
        for (nextField = field.getNextSibling(); nextField != null && !(nextField instanceof PsiField); nextField = nextField.getNextSibling()) {
        }
        return nextField != null && ((PsiField)nextField).getTypeElement() == typeElement;
    }

    private boolean isAvailableOnDeclarationStatement(PsiDeclarationStatement decl, PsiElement element) {
        PsiElement[] declaredElements = decl.getDeclaredElements();
        if (declaredElements.length == 0) {
            return false;
        }
        if (!(declaredElements[0] instanceof PsiLocalVariable)) {
            return false;
        }
        if (declaredElements.length == 1) {
            PsiLocalVariable var = (PsiLocalVariable)declaredElements[0];
            if (var.getInitializer() == null) {
                return false;
            }
            this.setText(CodeInsightBundle.message((String)"intention.split.declaration.assignment.text", (Object[])new Object[0]));
            return true;
        }
        if (declaredElements.length > 1) {
            if (decl.getParent() instanceof PsiForStatement) {
                return false;
            }
            this.setText(CodeInsightBundle.message((String)"intention.split.declaration.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SplitDeclarationAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SplitDeclarationAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (decl != null) {
            SplitDeclarationAction.invokeOnDeclarationStatement(decl, psiManager, project);
        } else {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            if (field != null) {
                field.normalizeDeclaration();
            }
        }
    }

    private static void invokeOnDeclarationStatement(PsiDeclarationStatement decl, PsiManager psiManager, Project project) throws IncorrectOperationException {
        if (decl.getDeclaredElements().length == 1) {
            PsiLocalVariable var = (PsiLocalVariable)decl.getDeclaredElements()[0];
            var.normalizeDeclaration();
            PsiExpressionStatement statement = (PsiExpressionStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText(var.getName() + "=xxx;", null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statement);
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression initializer = var.getInitializer();
            PsiExpression rExpression = RefactoringUtil.convertInitializerToNormalExpression(initializer, var.getType());
            assignment.getRExpression().replace((PsiElement)rExpression);
            initializer.delete();
            PsiElement block = decl.getParent();
            if (block instanceof PsiForStatement) {
                PsiDeclarationStatement varDeclStatement = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createVariableDeclarationStatement(var.getName(), var.getType(), null);
                for (PsiElement varDecl : varDeclStatement.getDeclaredElements()) {
                    if (!(varDecl instanceof PsiModifierListOwner)) continue;
                    PsiModifierList modList = ((PsiModifierListOwner)varDecl).getModifierList();
                    assert (modList != null);
                    modList.setModifierProperty("final", false);
                }
                PsiElement parent = block.getParent();
                decl.replace((PsiElement)statement);
                if (!(parent instanceof PsiCodeBlock)) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{}", null);
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    codeBlock.add((PsiElement)varDeclStatement);
                    codeBlock.add(block);
                    block.replace((PsiElement)blockStatement);
                } else {
                    parent.addBefore((PsiElement)varDeclStatement, block);
                }
            } else {
                block.addAfter((PsiElement)statement, (PsiElement)decl);
            }
        } else {
            ((PsiLocalVariable)decl.getDeclaredElements()[0]).normalizeDeclaration();
        }
    }
}

