/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetAbbreviationBalloon {
    private final String myAbbreviationsHistoryKey;
    private final String myLastAbbreviationKey;
    private final Callback myCallback;
    private final String myTitle;
    @Nullable
    private static String ourTestingAbbreviation;

    public EmmetAbbreviationBalloon(@NotNull String abbreviationsHistoryKey, @NotNull String lastAbbreviationKey, @NotNull Callback callback, @NotNull String title) {
        if (abbreviationsHistoryKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviationsHistoryKey", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "<init>"));
        }
        if (lastAbbreviationKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastAbbreviationKey", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "<init>"));
        }
        this.myAbbreviationsHistoryKey = abbreviationsHistoryKey;
        this.myLastAbbreviationKey = lastAbbreviationKey;
        this.myCallback = callback;
        this.myTitle = title;
    }

    public static void setTestingAbbreviation(@NotNull String testingAbbreviation, @NotNull Disposable parentDisposable) {
        if (testingAbbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testingAbbreviation", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "setTestingAbbreviation"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "setTestingAbbreviation"));
        }
        ourTestingAbbreviation = testingAbbreviation;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourTestingAbbreviation = null;
            }
        });
    }

    public void show(final @NotNull CustomTemplateCallback customTemplateCallback) {
        if (customTemplateCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customTemplateCallback", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "show"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ourTestingAbbreviation == null) {
                throw new RuntimeException("Testing abbreviation is not set. See EmmetAbbreviationBalloon#setTestingAbbreviation");
            }
            this.myCallback.onEnter(ourTestingAbbreviation);
            return;
        }
        final TextFieldWithStoredHistory field = new TextFieldWithStoredHistory(this.myAbbreviationsHistoryKey);
        Dimension fieldPreferredSize = field.getPreferredSize();
        field.setPreferredSize(new Dimension(Math.max(220, fieldPreferredSize.width), fieldPreferredSize.height));
        field.setHistorySize(10);
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final BalloonImpl balloon = (BalloonImpl)popupFactory.createDialogBalloonBuilder((JComponent)field, this.myTitle).setCloseButtonEnabled(false).setBlockClicksThroughBalloon(true).setAnimationCycle(0).setHideOnKeyOutside(true).setHideOnClickOutside(true).createBalloon();
        final DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!EmmetAbbreviationBalloon.isValid(customTemplateCallback)) {
                    balloon.hide();
                    return;
                }
                EmmetAbbreviationBalloon.validateTemplateKey((TextFieldWithHistory)field, balloon, field.getText(), customTemplateCallback);
            }
        };
        field.addDocumentListener((DocumentListener)documentListener);
        final KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon$3", "keyPressed"));
                }
                if (!field.isPopupVisible()) {
                    if (!EmmetAbbreviationBalloon.isValid(customTemplateCallback)) {
                        balloon.hide();
                        return;
                    }
                    switch (e.getKeyCode()) {
                        case 10: {
                            String abbreviation = field.getText();
                            if (!EmmetAbbreviationBalloon.validateTemplateKey((TextFieldWithHistory)field, balloon, abbreviation, customTemplateCallback)) break;
                            EmmetAbbreviationBalloon.this.myCallback.onEnter(abbreviation);
                            PropertiesComponent.getInstance().setValue(EmmetAbbreviationBalloon.this.myLastAbbreviationKey, abbreviation);
                            field.addCurrentTextToHistory();
                            balloon.hide();
                            break;
                        }
                        case 27: {
                            balloon.hide(false);
                        }
                    }
                }
            }
        };
        field.addKeyboardListener((KeyListener)keyListener);
        balloon.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void beforeShown(LightweightWindowEvent event) {
                field.setText(PropertiesComponent.getInstance().getValue(EmmetAbbreviationBalloon.this.myLastAbbreviationKey, ""));
            }

            public void onClosed(LightweightWindowEvent event) {
                field.removeKeyListener((KeyListener)keyListener);
                field.removeDocumentListener((DocumentListener)documentListener);
                super.onClosed(event);
            }
        });
        balloon.show(popupFactory.guessBestPopupLocation(customTemplateCallback.getEditor()), Balloon.Position.below);
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)customTemplateCallback.getProject());
        focusManager.doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                focusManager.requestFocus((Component)field, true);
                field.selectText();
            }
        });
    }

    private static boolean validateTemplateKey(@NotNull TextFieldWithHistory field, @Nullable Balloon balloon, @NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "validateTemplateKey"));
        }
        if (abbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "validateTemplateKey"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon", "validateTemplateKey"));
        }
        boolean correct = ZenCodingTemplate.checkTemplateKey(abbreviation, callback);
        field.getTextEditor().setBackground(correct ? LightColors.SLIGHTLY_GREEN : LightColors.RED);
        if (balloon != null && !balloon.isDisposed()) {
            balloon.revalidate();
        }
        return correct;
    }

    private static boolean isValid(CustomTemplateCallback callback) {
        return !callback.getEditor().isDisposed();
    }

    public static interface Callback {
        public void onEnter(@NotNull String var1);
    }
}

