/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ShortenToStaticImportProcessor
implements TemplateOptionalProcessor {
    private static final List<StaticImporter> IMPORTERS = Arrays.asList(new SingleMemberStaticImporter(), new OnDemandStaticImporter());

    @Override
    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        if (!template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file2 == null) {
            return;
        }
        ArrayList<Pair> staticImportTargets = new ArrayList<Pair>();
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)templateRange.getStartOffset());
        while (element != null && element.getTextRange().getStartOffset() < templateRange.getEndOffset()) {
            for (StaticImporter importer : IMPORTERS) {
                if (!importer.canPerform(element)) continue;
                staticImportTargets.add(Pair.create((Object)element, (Object)importer));
                break;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        Collections.reverse(staticImportTargets);
        for (Pair pair : staticImportTargets) {
            if (!((PsiElement)pair.first).isValid()) continue;
            ((StaticImporter)pair.second).perform(project, file2, editor, (PsiElement)pair.first);
        }
    }

    @Override
    @Nls
    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.use.static.import", (Object[])new Object[0]);
    }

    @Override
    public boolean isEnabled(Template template) {
        return template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE);
    }

    @Override
    public void setEnabled(Template template, boolean value) {
        template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, value);
    }

    @Override
    public boolean isVisible(Template template) {
        return true;
    }

    private static class OnDemandStaticImporter
    implements StaticImporter {
        private OnDemandStaticImporter() {
        }

        @Override
        public boolean canPerform(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/impl/ShortenToStaticImportProcessor$OnDemandStaticImporter", "canPerform"));
            }
            return AddOnDemandStaticImportAction.getClassToPerformStaticImport(element) != null;
        }

        @Override
        public void perform(Project project, PsiFile file2, Editor editor, PsiElement element) {
            AddOnDemandStaticImportAction.invoke(project, file2, editor, element);
        }
    }

    private static class SingleMemberStaticImporter
    implements StaticImporter {
        private SingleMemberStaticImporter() {
        }

        @Override
        public boolean canPerform(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/impl/ShortenToStaticImportProcessor$SingleMemberStaticImporter", "canPerform"));
            }
            return AddSingleMemberStaticImportAction.getStaticImportClass(element) != null;
        }

        @Override
        public void perform(Project project, PsiFile file2, Editor editor, PsiElement element) {
            AddSingleMemberStaticImportAction.invoke(file2, element);
        }
    }

    private static interface StaticImporter {
        public boolean canPerform(@NotNull PsiElement var1);

        public void perform(Project var1, PsiFile var2, Editor var3, PsiElement var4);
    }
}

