/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.InterpreterExt;
import com.intellij.codeInspection.bytecodeAnalysis.asm.Subroutine;
import com.intellij.codeInspection.bytecodeAnalysis.asm.SubroutineFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class AnalyzerExt<V extends Value, Data, MyInterpreter extends Interpreter<V>>
extends SubroutineFinder {
    private final MyInterpreter interpreter;
    private Frame<V>[] frames;
    private boolean[] queued;
    private int[] queue;
    private int top;
    private final Data[] data;

    public Data[] getData() {
        return this.data;
    }

    public AnalyzerExt(MyInterpreter interpreter, Data[] data, Data startData) {
        this.interpreter = interpreter;
        this.data = data;
        if (data.length > 0) {
            data[0] = startData;
        }
    }

    public Frame<V>[] analyze(String owner, MethodNode m) throws AnalyzerException {
        if ((m.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        BasicValue refV = BasicValue.REFERENCE_VALUE;
        this.n = m.instructions.size();
        this.insns = m.instructions;
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (int i = 0; i < m.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)m.tryCatchBlocks.get(i);
            int begin = this.insns.indexOf((AbstractInsnNode)tcb.start);
            int end = this.insns.indexOf((AbstractInsnNode)tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Subroutine main = new Subroutine(null, m.maxLocals, null);
        ArrayList<AbstractInsnNode> subroutineCalls = new ArrayList<AbstractInsnNode>();
        HashMap<LabelNode, Subroutine> subroutineHeads = new HashMap<LabelNode, Subroutine>();
        this.findSubroutine(0, main, subroutineCalls);
        while (!subroutineCalls.isEmpty()) {
            JumpInsnNode jsr = (JumpInsnNode)subroutineCalls.remove(0);
            Subroutine sub = (Subroutine)subroutineHeads.get(jsr.label);
            if (sub == null) {
                sub = new Subroutine(jsr.label, m.maxLocals, jsr);
                subroutineHeads.put(jsr.label, sub);
                this.findSubroutine(this.insns.indexOf((AbstractInsnNode)jsr.label), sub, subroutineCalls);
                continue;
            }
            sub.callers.add(jsr);
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.subroutines[i] == null || this.subroutines[i].start != null) continue;
            this.subroutines[i] = null;
        }
        Frame<V> current = this.newFrame(m.maxLocals, m.maxStack);
        Frame<V> handler2 = this.newFrame(m.maxLocals, m.maxStack);
        current.setReturn(this.interpreter.newValue(Type.getReturnType((String)m.desc)));
        Type[] args = Type.getArgumentTypes((String)m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType((String)owner);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        for (int i = 0; i < args.length; ++i) {
            current.setLocal(local++, this.interpreter.newValue(args[i]));
            if (args[i].getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        ((InterpreterExt)this.interpreter).init(this.data[0]);
        this.merge(0, current, null);
        this.init(owner, m);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame<V> f = this.frames[insn];
            Subroutine subroutine = this.subroutines[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    ((InterpreterExt)this.interpreter).init(this.data[insn]);
                    this.merge(insn + 1, f, subroutine);
                    this.newControlFlowEdge(insn, insn + 1);
                } else {
                    int j;
                    int jump;
                    ((InterpreterExt)this.interpreter).init(this.data[insn]);
                    current.init(f).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current, subroutine);
                            this.newControlFlowEdge(insn, insn + 1);
                        }
                        jump = this.insns.indexOf((AbstractInsnNode)j2.label);
                        if (insnOpcode == 168) {
                            this.merge(jump, current, new Subroutine(j2.label, m.maxLocals, j2));
                        } else {
                            this.merge(jump, current, subroutine);
                        }
                        this.newControlFlowEdge(insn, jump);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        jump = this.insns.indexOf((AbstractInsnNode)lsi.dflt);
                        this.merge(jump, current, subroutine);
                        this.newControlFlowEdge(insn, jump);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            LabelNode label = (LabelNode)lsi.labels.get(j);
                            jump = this.insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current, subroutine);
                            this.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        jump = this.insns.indexOf((AbstractInsnNode)tsi.dflt);
                        this.merge(jump, current, subroutine);
                        this.newControlFlowEdge(insn, jump);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            LabelNode label = (LabelNode)tsi.labels.get(j);
                            jump = this.insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current, subroutine);
                            this.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i = 0; i < subroutine.callers.size(); ++i) {
                            JumpInsnNode caller = subroutine.callers.get(i);
                            int call = this.insns.indexOf((AbstractInsnNode)caller);
                            if (this.frames[call] == null) continue;
                            this.merge(call + 1, this.frames[call], current, this.subroutines[call], subroutine.access);
                            this.newControlFlowEdge(insn, call + 1);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.access[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                            }
                        }
                        this.merge(insn + 1, current, subroutine);
                        this.newControlFlowEdge(insn, insn + 1);
                    }
                }
                if ((insnHandlers = this.handlers[insn]) == null) continue;
                for (int i = 0; i < insnHandlers.size(); ++i) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)insnHandlers.get(i);
                    int jump = this.insns.indexOf((AbstractInsnNode)tcb.handler);
                    if (!this.newControlFlowExceptionEdge(insn, tcb)) continue;
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push((Value)refV);
                    this.merge(jump, handler2, subroutine);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return this.frames;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int insn) {
        return this.handlers[insn];
    }

    protected void init(String owner, MethodNode m) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> src) {
        return new Frame(src);
    }

    protected void newControlFlowEdge(int insn, int successor) {
    }

    protected boolean newControlFlowExceptionEdge(int insn, int successor) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
        return this.newControlFlowExceptionEdge(insn, this.insns.indexOf((AbstractInsnNode)tcb.handler));
    }

    private void merge(int insn, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, this.interpreter);
        }
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insn] = subroutine.copy();
                changes = true;
            }
        } else if (subroutine != null) {
            changes |= oldSubroutine.merge(subroutine);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
        this.mergeData(insn, this.interpreter);
    }

    private void merge(int insn, Frame<V> beforeJSR, Frame<V> afterRET, Subroutine subroutineBeforeJSR, boolean[] access) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        afterRET.merge(beforeJSR, access);
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(afterRET);
            changes = true;
        } else {
            changes = oldFrame.merge(afterRET, this.interpreter);
        }
        if (oldSubroutine != null && subroutineBeforeJSR != null) {
            changes |= oldSubroutine.merge(subroutineBeforeJSR);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
        this.mergeData(insn, this.interpreter);
    }

    private void mergeData(int insn, MyInterpreter interpreter) {
        boolean changes = false;
        Data oldData = this.data[insn];
        Object newData = ((InterpreterExt)interpreter).getAfterData(insn);
        if (oldData == null) {
            this.data[insn] = newData;
            changes = true;
        } else if (newData != null) {
            Data mergedData;
            this.data[insn] = mergedData = ((InterpreterExt)interpreter).merge(oldData, newData);
            boolean bl = changes = !oldData.equals(mergedData);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }
}

