/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaPsiUtil {
    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        Object codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    @NotNull
    public static Nullness getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (owner instanceof PsiEnumConstant) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (resultType != null) {
            NullableNotNullManager nnn = NullableNotNullManager.getInstance((Project)owner.getProject());
            for (PsiAnnotation annotation : resultType.getAnnotations()) {
                if (!annotation.isValid()) {
                    PsiUtilCore.ensureValid((PsiElement)owner);
                    PsiUtil.ensureValidType((PsiType)resultType, (String)(owner + " of " + owner.getClass()));
                    PsiUtilCore.ensureValid((PsiElement)annotation);
                }
                String qualifiedName = annotation.getQualifiedName();
                if (nnn.getNullables().contains(qualifiedName)) {
                    Nullness nullness = Nullness.NULLABLE;
                    if (nullness == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
                    }
                    return nullness;
                }
                if (!nnn.getNotNulls().contains(qualifiedName)) continue;
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
                }
                return nullness;
            }
        }
        if (NullableNotNullManager.isNullable((PsiModifierListOwner)owner)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
        }
        return nullness;
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (DfaPsiUtil.getNotNullInitializedFields(method, containingClass).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getNotNullInitializedFields(final PsiMethod constructor, final PsiClass containingClass) {
        if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Collections.emptySet();
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)constructor, (CachedValueProvider)new CachedValueProvider<Set<PsiField>>(){

            @Nullable
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                PsiCodeBlock body = constructor.getBody();
                final HashMap map = ContainerUtil.newHashMap();
                StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, false){

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        if (!(instruction instanceof MethodCallInstruction) || ((MethodCallInstruction)instruction).getMethodType() != MethodCallInstruction.MethodType.REGULAR_METHOD_CALL) {
                            return false;
                        }
                        PsiCallExpression call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiMethodCallExpression && DfaValueFactory.isEffectivelyUnqualified(((PsiMethodCallExpression)call).getMethodExpression())) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression : argumentList.getExpressions()) {
                                if (!(expression instanceof PsiThisExpression)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    protected DfaInstructionState[] acceptInstruction(InstructionVisitor visitor, DfaInstructionState instructionState) {
                        Instruction instruction = instructionState.getInstruction();
                        if (this.isCallExposingNonInitializedFields(instruction) || instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
                            for (PsiField field : containingClass.getFields()) {
                                if (!instructionState.getMemoryState().isNotNull(this.getFactory().getVarFactory().createVariableValue((PsiVariable)field, false))) {
                                    map.put(field, false);
                                    continue;
                                }
                                if (map.containsKey(field)) continue;
                                map.put(field, true);
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        return super.acceptInstruction(visitor, instructionState);
                    }
                };
                RunnerResult rc = dfaRunner.analyzeMethod((PsiElement)body, new StandardInstructionVisitor());
                HashSet notNullFields = ContainerUtil.newHashSet();
                if (rc == RunnerResult.OK) {
                    for (PsiField field : map.keySet()) {
                        if (!((Boolean)map.get(field)).booleanValue()) continue;
                        notNullFields.add(field);
                    }
                }
                return CachedValueProvider.Result.create((Object)notNullFields, (Object[])new Object[]{constructor, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    public static List<PsiExpression> findAllConstructorInitializers(PsiField field) {
        List result2 = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull((Collection)result2, (Object)field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result2.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get((Object)field));
        }
        return result2;
    }

    private static MultiMap<PsiField, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.EMPTY;
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<MultiMap<PsiField, PsiExpression>>(){

            @Nullable
            public CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> compute() {
                final HashSet fieldNames = ContainerUtil.newHashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull((Collection)fieldNames, (Object)field.getName());
                }
                final MultiMap result2 = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                        PsiElement target;
                        super.visitAssignmentExpression(assignment);
                        PsiExpression lExpression = assignment.getLExpression();
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && lExpression instanceof PsiReferenceExpression && fieldNames.contains(((PsiReferenceExpression)lExpression).getReferenceName()) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField && ((PsiField)target).getContainingClass() == psiClass) {
                            result2.putValue((Object)((PsiField)target), (Object)rExpression);
                        }
                    }
                };
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) continue;
                    constructor.accept((PsiElementVisitor)visitor);
                }
                return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{psiClass});
            }
        });
    }

    @Nullable
    public static PsiCodeBlock getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTopmostBlockInSameClass"));
        }
        PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        if (block == null) {
            return null;
        }
        PsiCodeBlock lastBlock = block;
        while ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiFile.class})) != null) {
            lastBlock = block;
        }
        return lastBlock;
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, final boolean literalsOnly, PsiElement place) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
        }
        final Ref modificationRef = Ref.create((Object)Boolean.FALSE);
        final PsiCodeBlock codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        final int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        List list = ContainerUtil.mapNotNull((Collection)ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)new LocalSearchScope(new PsiElement[]{psiVariable.getContainingFile()}, null, true)).findAll(), (Function)new NullableFunction<PsiReference, PsiExpression>(){

            public PsiExpression fun(PsiReference psiReference) {
                if (((Boolean)modificationRef.get()).booleanValue()) {
                    return null;
                }
                PsiElement parent = psiReference.getElement().getParent();
                if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                    IElementType operation = assignmentExpression.getOperationTokenType();
                    if (assignmentExpression.getLExpression() == psiReference) {
                        if (JavaTokenType.EQ.equals(operation)) {
                            PsiExpression rValue = assignmentExpression.getRExpression();
                            if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                                if (codeBlock != null && PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)parent, (boolean)true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                    return null;
                                }
                                return rValue;
                            }
                            modificationRef.set((Object)Boolean.TRUE);
                        } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                            modificationRef.set((Object)Boolean.TRUE);
                        }
                    }
                }
                return null;
            }
        });
        if (((Boolean)modificationRef.get()).booleanValue()) {
            List<PsiExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
            }
            return list2;
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat((List)list, Collections.singletonList(initializer));
        }
        List list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
        }
        return list3;
    }

    public static boolean allOperandsAreLiterals(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            Stack stack = new Stack();
            stack.add((Object)expression);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push((Object)op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

