/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.FluentIterableMethodTransformer;
import com.intellij.codeInspection.java18StreamApi.GuavaFluentIterableInspection;
import com.intellij.codeInspection.java18StreamApi.GuavaOptionalConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFluentIterableMethodConverters {
    private static final Logger LOG = Logger.getInstance(GuavaFluentIterableMethodConverters.class);
    private static final Map<String, FluentIterableMethodTransformer> METHOD_INDEX = new HashMap<String, FluentIterableMethodTransformer>();
    private static final Map<String, String> TO_OTHER_COLLECTION_METHODS = new HashMap<String, String>();
    private static final Set<String> STOP_METHODS = new HashSet<String>();
    private final PsiElementFactory myElementFactory;

    public GuavaFluentIterableMethodConverters(PsiElementFactory elementFactory) {
        this.myElementFactory = elementFactory;
    }

    public static boolean isFluentIterableMethod(String methodName) {
        return STOP_METHODS.contains(methodName) || TO_OTHER_COLLECTION_METHODS.containsKey(methodName) || METHOD_INDEX.containsKey(methodName);
    }

    public static boolean isStopMethod(String methodName) {
        return STOP_METHODS.contains(methodName);
    }

    public PsiLocalVariable convert(PsiLocalVariable localVariable) {
        PsiTypeElement typeElement = localVariable.getTypeElement();
        PsiReferenceParameterList generics = (PsiReferenceParameterList)PsiTreeUtil.findChildOfType((PsiElement)typeElement, PsiReferenceParameterList.class);
        typeElement.replace((PsiElement)this.myElementFactory.createTypeElementFromText("java.util.stream.Stream" + (generics == null ? "" : generics.getText()), null));
        PsiExpression initializer = localVariable.getInitializer();
        if (initializer != null) {
            this.convertMethodCallDeep((PsiMethodCallExpression)initializer);
        }
        return localVariable;
    }

    public PsiElement convert(PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            PsiElement expressionParent = expression.getParent();
            if (expressionParent instanceof PsiReturnStatement || GuavaFluentIterableMethodConverters.isIterableMethodParameter(expressionParent, expression)) {
                return this.addCollectionToList((PsiElement)expression);
            }
            return null;
        }
        PsiMethodCallExpression parentMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
        if (parentMethodCall != null && parentMethodCall.getMethodExpression().getQualifierExpression() == expression) {
            PsiMethod seqTailMethod = parentMethodCall.resolveMethod();
            if (seqTailMethod == null) {
                return null;
            }
            PsiClass seqTailMethodClass = seqTailMethod.getContainingClass();
            if (seqTailMethodClass != null && "com.google.common.base.Optional".equals(seqTailMethodClass.getQualifiedName())) {
                PsiMethodCallExpression newParentMethodCall = GuavaOptionalConverter.convertGuavaOptionalToJava(parentMethodCall, this.myElementFactory);
                expression = newParentMethodCall.getMethodExpression().getQualifierExpression();
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            expression = this.convertMethodCallDeep((PsiMethodCallExpression)expression);
        }
        if (expression == null) {
            return null;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpressionList) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent.getParent();
            Object[] expressions = methodCall.getArgumentList().getExpressions();
            int index = ArrayUtil.indexOf((Object[])expressions, (Object)expression);
            LOG.assertTrue(index >= 0);
            PsiMethod method = methodCall.resolveMethod();
            LOG.assertTrue(method != null);
            PsiType parameterType = method.getParameterList().getParameters()[index].getType();
            return this.addCollectToListIfNeed(expression, parameterType);
        }
        if (parent instanceof PsiReturnStatement) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
            LOG.assertTrue(containingMethod != null);
            PsiType returnType = containingMethod.getReturnType();
            return this.addCollectToListIfNeed(expression, returnType);
        }
        return expression;
    }

    private PsiExpression addCollectToListIfNeed(PsiExpression expression, PsiType type) {
        if (type instanceof PsiClassType && ((PsiClassType)type).rawType().equalsToText("java.lang.Iterable")) {
            return (PsiExpression)this.addCollectionToList((PsiElement)expression);
        }
        return expression;
    }

    private PsiElement addCollectionToList(PsiElement expression) {
        return expression.replace((PsiElement)this.myElementFactory.createExpressionFromText(expression.getText() + ".collect(java.util.stream.Collectors.toList())", null));
    }

    private static boolean isIterableMethodParameter(PsiElement listExpression, PsiExpression parameterExpression) {
        if (!(listExpression instanceof PsiExpressionList)) {
            return false;
        }
        if (!(listExpression.getParent() instanceof PsiMethodCallExpression)) {
            return false;
        }
        Project project = parameterExpression.getProject();
        PsiClass fluentIterable = JavaPsiFacade.getInstance((Project)project).findClass("com.google.common.collect.FluentIterable", listExpression.getResolveScope());
        return GuavaFluentIterableInspection.isMethodWithParamAcceptsConversion((PsiMethodCallExpression)listExpression.getParent(), parameterExpression, fluentIterable);
    }

    @Nullable
    private PsiMethodCallExpression convertMethodCallDeep(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableMethodConverters", "convertMethodCallDeep"));
        }
        PsiMethodCallExpression newMethodCall = methodCall;
        PsiMethodCallExpression returnCall = null;
        while (true) {
            PsiExpression expression;
            PsiReferenceExpression methodExpression = newMethodCall.getMethodExpression();
            String name = methodExpression.getReferenceName();
            PsiMethodCallExpression converted = this.convertFromMethodCall(newMethodCall);
            if (converted != null) {
                return returnCall;
            }
            if (TO_OTHER_COLLECTION_METHODS.containsKey(name)) {
                converted = this.convertToCollection(newMethodCall, name);
            } else {
                FluentIterableMethodTransformer transformer = METHOD_INDEX.get(name);
                LOG.assertTrue(transformer != null, (Object)name);
                converted = transformer.transform(newMethodCall, this.myElementFactory);
            }
            if (converted == null) {
                return returnCall;
            }
            if (returnCall == null) {
                returnCall = converted;
            }
            if (!((expression = (newMethodCall = converted).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression)) break;
            newMethodCall = (PsiMethodCallExpression)expression;
        }
        return returnCall;
    }

    private PsiMethodCallExpression convertFromMethodCall(PsiMethodCallExpression methodCall) {
        if ("from".equals(methodCall.getMethodExpression().getReferenceName())) {
            PsiExpression[] argumentList = methodCall.getArgumentList().getExpressions();
            LOG.assertTrue(argumentList.length == 1);
            PsiExpression expression = argumentList[0];
            PsiType type = expression.getType();
            LOG.assertTrue(type instanceof PsiClassType);
            String newExpressionText = InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection") ? expression.getText() + ".stream()" : "java.util.stream.StreamSupport.stream(" + expression.getText() + ".spliterator(), false)";
            return (PsiMethodCallExpression)methodCall.replace((PsiElement)this.myElementFactory.createExpressionFromText(newExpressionText, null));
        }
        return null;
    }

    private PsiMethodCallExpression convertToCollection(PsiMethodCallExpression methodCall, String methodName) {
        PsiExpression qualifier;
        PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
        LOG.assertTrue(expressions.length < 2);
        String template = TO_OTHER_COLLECTION_METHODS.get(methodName);
        if (expressions.length == 1) {
            template = String.format(template, expressions[0].getText());
        }
        if ((qualifier = methodCall.getMethodExpression().getQualifierExpression()) == null) {
            return null;
        }
        PsiExpression expression = this.myElementFactory.createExpressionFromText(qualifier.getText() + "." + template, null);
        return (PsiMethodCallExpression)methodCall.replace((PsiElement)expression);
    }

    static {
        METHOD_INDEX.put("allMatch", new FluentIterableMethodTransformer.OneParameterMethodTransformer("allMatch(%s)", true));
        METHOD_INDEX.put("anyMatch", new FluentIterableMethodTransformer.OneParameterMethodTransformer("anyMatch(%s)", true));
        METHOD_INDEX.put("contains", new FluentIterableMethodTransformer.OneParameterMethodTransformer("anyMatch(e -> e != null && e.equals(%s))"));
        METHOD_INDEX.put("copyInto", new FluentIterableMethodTransformer.OneParameterMethodTransformer("forEach(%s::add)"));
        METHOD_INDEX.put("filter", new FluentIterableMethodTransformer.OneParameterMethodTransformer("filter(%s)", true));
        METHOD_INDEX.put("first", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("findFirst"));
        METHOD_INDEX.put("firstMatch", new FluentIterableMethodTransformer.OneParameterMethodTransformer("filter(%s).findFirst()", true));
        METHOD_INDEX.put("get", new FluentIterableMethodTransformer.OneParameterMethodTransformer("collect(java.util.stream.Collectors.toList()).get(%s)"));
        METHOD_INDEX.put("index", new FluentIterableMethodTransformer.OneParameterMethodTransformer("collect(java.util.stream.Collectors.toList()).indexOf(%s)"));
        METHOD_INDEX.put("isEmpty", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("findAny().isPresent()", true));
        METHOD_INDEX.put("last", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("reduce((previous, current) -> current)"));
        METHOD_INDEX.put("limit", new FluentIterableMethodTransformer.OneParameterMethodTransformer("limit(%s)"));
        METHOD_INDEX.put("size", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("collect(java.util.stream.Collectors.toList()).size()"));
        METHOD_INDEX.put("skip", new FluentIterableMethodTransformer.OneParameterMethodTransformer("skip(%s)"));
        METHOD_INDEX.put("toArray", new FluentIterableMethodTransformer.ToArrayMethodTransformer());
        METHOD_INDEX.put("transform", new FluentIterableMethodTransformer.OneParameterMethodTransformer("map(%s)", true));
        METHOD_INDEX.put("transformAndConcat", new FluentIterableMethodTransformer.OneParameterMethodTransformer("flatMap(%s)", true));
        METHOD_INDEX.put("uniqueIndex", new FluentIterableMethodTransformer.OneParameterMethodTransformer("collect(java.util.stream.Collectors.toMap(%s, java.util.function.Function.identity()))"));
        TO_OTHER_COLLECTION_METHODS.put("toMap", "collect(java.util.stream.Collectors.toMap(java.util.function.Function.identity(), %s))");
        TO_OTHER_COLLECTION_METHODS.put("toList", "collect(java.util.stream.Collectors.toList())");
        TO_OTHER_COLLECTION_METHODS.put("toSet", "collect(java.util.stream.Collectors.toSet())");
        TO_OTHER_COLLECTION_METHODS.put("toSortedList", "sorted(%s).collect(java.util.stream.Collectors.toList())");
        TO_OTHER_COLLECTION_METHODS.put("toSortedSet", "sorted(%s).collect(java.util.stream.Collectors.toSet())");
        STOP_METHODS.add("append");
        STOP_METHODS.add("cycle");
    }
}

