/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;

public class CompileAction
extends CompileActionBase {
    @Override
    protected void doAction(DataContext dataContext, Project project) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (module != null) {
            CompilerManager.getInstance((Project)project).compile(module, null);
        } else {
            VirtualFile[] files = CompileAction.getCompilableFiles(project, (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
            if (files.length > 0) {
                CompilerManager.getInstance((Project)project).compile(files, null);
            }
        }
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        presentation.setText(ActionsBundle.actionText((String)"Compile"));
        presentation.setVisible(true);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        VirtualFile[] files = CompileAction.getCompilableFiles(project, (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
        if (module == null && files.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isPopupPlace((String)event.getPlace()));
            return;
        }
        String elementDescription = null;
        if (module != null) {
            elementDescription = CompilerBundle.message((String)"action.compile.description.module", (Object[])new Object[]{module.getName()});
        } else {
            PsiPackage aPackage = null;
            if (files.length == 1) {
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(files[0]);
                if (directory != null) {
                    aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                }
            } else {
                PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (element instanceof PsiPackage) {
                    aPackage = (PsiPackage)element;
                }
            }
            if (aPackage != null) {
                String name = aPackage.getQualifiedName();
                if (name.length() == 0) {
                    name = "<default>";
                }
                elementDescription = "'" + name + "'";
            } else if (files.length == 1) {
                VirtualFile file2 = files[0];
                FileType fileType = file2.getFileType();
                if (CompilerManager.getInstance((Project)project).isCompilableFileType(fileType) || compilerConfiguration.isCompilableResourceFile(project, file2)) {
                    elementDescription = "'" + file2.getName() + "'";
                } else if (!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
                    presentation.setEnabled(false);
                    presentation.setVisible(false);
                    return;
                }
            } else {
                elementDescription = CompilerBundle.message((String)"action.compile.description.selected.files", (Object[])new Object[0]);
            }
        }
        if (elementDescription == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setText(CompileAction.createPresentationText(elementDescription), true);
        presentation.setEnabled(true);
    }

    private static String createPresentationText(String elementDescription) {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(ActionsBundle.actionText((String)"Compile")).append(" ");
        int length = elementDescription.length();
        if (length > 23) {
            if (StringUtil.startsWithChar((CharSequence)elementDescription, (char)'\'')) {
                buffer.append("'");
            }
            buffer.append("...");
            buffer.append(elementDescription.substring(length - 20, length));
        } else {
            buffer.append(elementDescription);
        }
        return buffer.toString();
    }

    private static VirtualFile[] getCompilableFiles(Project project, VirtualFile[] files) {
        if (files == null || files.length == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            FileType fileType;
            PsiDirectory directory;
            if (!fileIndex.isInSourceContent(file2) || !file2.isInLocalFileSystem() || (file2.isDirectory() ? (directory = psiManager.findDirectory(file2)) == null || JavaDirectoryService.getInstance().getPackage(directory) == null : !compilerManager.isCompilableFileType(fileType = file2.getFileType()) && !compilerConfiguration.isCompilableResourceFile(project, file2))) continue;
            filesToCompile.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(filesToCompile);
    }
}

