/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Comparator;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"9\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001\u0012E\u0003\u0002\u0011\u0007)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A\t\"B\u0001\u0005\u00045\u0015C\u0001\u0001\u0005\u0004\u001b\u0015I!!C\u0001\u0019\t1\u0005\u0001tA\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0019!-QBC\u0005\t\u0013\u001dI!!C\u0001\u0019\u000b%\u0011\u0011\"\u0001M\u00071\u0019A:!G\u0004\t\u000f5)\u0011BA\u0005\u00021\u0011a\t\u0001g\u0002U\u0007\u000biq\u0002B\u0001\t\u00105\t\u0001\u0004C\r\u0007\u0011#iA!\u0003\u0002\n\u0003aA\u0001$C)\u0004\u0003!MAk!\u0002\u000e'\u0011\u0001\u0001BC\u0007\u0006\u0013\r!\t!C\u0001\u0019\u0011aI\u0011D\u0002E\t\u001b\u0011I!!C\u0001\u0019\u0011aI\u0011kA\u0001\t\u0016Q\u001b)!\u0005\b\u0005\u0001\"A\u0001!d\u0002\u0019\u0002E\u001b\u0011\u0001B\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0004!\u0011Ak!\u0002"}, strings={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ComponentStoreImplKt", "executeSave", "", "", "session", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "readonlyFiles", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "previousErrors", "findNonDeprecated", "Lcom/intellij/openapi/components/Storage;", "storages", "", "([Lcom/intellij/openapi/components/Storage;)Lcom/intellij/openapi/components/Storage;", "sortStoragesByDeprecated", "([Lcom/intellij/openapi/components/Storage;)[Lcom/intellij/openapi/components/Storage;"}, moduleName="configuration-store-impl")
public final class ComponentStoreImplKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @Nullable
    public static final List<Throwable> executeSave(@NotNull StateStorage.SaveSession session, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> previousErrors) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List errors = previousErrors;
        try {
            session.save();
        }
        catch (ReadOnlyModificationException e) {
            LOG.warn((Throwable)e);
            StateStorage.SaveSession saveSession = e.getSession();
            if (saveSession == null) {
                saveSession = session;
            }
            Pair pair = Pair.create((Object)saveSession, (Object)e.getFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"JBPair.create<SaveSessio\u2026ssion ?: session, e.file)");
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)pair);
        }
        catch (Exception e) {
            if (errors == null) {
                errors = (List)new SmartList();
            }
            errors.add((Throwable)e);
        }
        return errors;
    }

    private static final Storage findNonDeprecated(Storage[] storages) {
        for (int i = 0; i < storages.length; ++i) {
            Storage storage2 = storages[i];
            if (storage2.deprecated()) continue;
            return storage2;
        }
        throw (Throwable)((Object)new AssertionError((Object)"All storages are deprecated"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Storage[] sortStoragesByDeprecated(@NotNull Storage[] storages) {
        Intrinsics.checkParameterIsNotNull((Object)storages, (String)"storages");
        if (ArraysKt.isEmpty((Object[])storages)) {
            return storages;
        }
        if (!storages[0].deprecated()) {
            boolean othersAreDeprecated = true;
            int n = 1;
            int n2 = ((Object[])storages).length - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (!storages[i].deprecated()) {
                        othersAreDeprecated = false;
                        break;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (othersAreDeprecated) {
                return storages;
            }
        }
        Object[] objectArray = storages;
        Comparator comparator2 = new Comparator<T>(){

            /*
             * WARNING - void declaration
             */
            public int compare(T a, T b) {
                void o2;
                Storage storage2 = (Storage)b;
                Storage o1 = (Storage)a;
                int w1 = o1.deprecated() ? 1 : 0;
                int w2 = o2.deprecated() ? 1 : 0;
                return w1 - w2;
            }
        };
        return (Storage[])ArraysKt.sortedArrayWith((Object[])objectArray, (Comparator)comparator2);
    }

    @NotNull
    public static final /* synthetic */ Storage access$findNonDeprecated(@NotNull Storage[] storages) {
        return ComponentStoreImplKt.findNonDeprecated(storages);
    }
}

