/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SaveSessionBaseKt;
import com.intellij.configurationStore.StorageBaseEx;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.components.PersistentStateComponent;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001C\u0001\u0006\u0003\u0011\rA\u0002A\u000b\u0005\t\u0001A\t!F\u0001\u0019\u0003U!A\u0011\u0001E\u0002+\u0005A\u0012!G\u0001\u0019\u0003\u0005~\u0012B\u0002\u0005\u0003\u001b\u0011I!!C\u0001\u001d\u0001a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!C\u0002\t\t5\tA\u0014A\u0005\u0007\u0011\u0013iA!\u0003\u0002\n\u0003q\u0001\u0001$B\u0005\u0007\u0011\u0017iA!\u0003\u0002\n\u0003q\u0005\u0001DB)\u0004\u0003!5Qe\u0001E\u000b\u001b\u0005A2\"*\u0007\t\u00185\u0011A\u0012\u0001\u000f\u00013\u0015!\u0011\u0001\u0003\u0007\u000e\u00051\u0005A\u0004A)\u0004\u0003!e\u0011F\u0003\u0003B\u0011!\u0011Q\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001'\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A1!D\u0001\u0019\bE\u001b\u0011!\u0002\u0001*\u001d\u0011\u0019E\u0004C\u0004\u000e\u00051\u0005\u0001tB)\u0004\u000f\u0015\u0001QB\u0001\u0003\t\u0011#\t\"\u0001B\u0005\t\u0014%RA!\u0011\u0005\t\n5!\u0011BA\u0005\u00029\u0001AR!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\u0017iA!\u0003\u0002\n\u0003q\u0005\u0001DB)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B\u0011!!Q\"\u0001O\u0001#\u000e\u0011Q!\u0001\u0005\u000b"}, strings={"Lcom/intellij/configurationStore/StateGetter;", "S", "", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "componentName", "", "storageData", "stateClass", "Ljava/lang/Class;", "storage", "Lcom/intellij/configurationStore/StorageBaseEx;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;Lcom/intellij/configurationStore/StorageBaseEx;)V", "serializedState", "Lorg/jdom/Element;", "getSerializedState", "()Lorg/jdom/Element;", "setSerializedState", "(Lorg/jdom/Element;)V", "Ljava/lang/Object;", "close", "", "getState", "mergeInto", "(Ljava/lang/Object;)Ljava/lang/Object;"}, moduleName="configuration-store-impl")
public final class StateGetter<S, T> {
    @Nullable
    private Element serializedState;
    private final PersistentStateComponent<S> component;
    private final String componentName;
    private final T storageData;
    private final Class<S> stateClass;
    private final StorageBaseEx<T> storage;

    @Nullable
    public final Element getSerializedState() {
        return this.serializedState;
    }

    public final void setSerializedState(@Nullable Element element) {
        this.serializedState = element;
    }

    @Nullable
    public final S getState(@Nullable S mergeInto) {
        ComponentStoreImplKt.getLOG().assertTrue(this.serializedState == null);
        this.serializedState = this.storage.getSerializedState(this.storageData, this.component, this.componentName, false);
        boolean bl = this.serializedState != null;
        return this.storage.deserializeState(this.serializedState, this.stateClass, mergeInto);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Object getState$default(StateGetter stateGetter, Object object, int n) {
        if ((n & 1) != 0) {
            object = null;
        }
        return stateGetter.getState(object);
    }

    public final void close() {
        Object object;
        Object stateAfterLoad;
        if (this.serializedState == null) {
            return;
        }
        try {
            stateAfterLoad = this.component.getState();
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot get state after load", e);
            stateAfterLoad = null;
        }
        if (stateAfterLoad == null) {
            object = this.serializedState;
        } else {
            Element element = SaveSessionBaseKt.serializeState(stateAfterLoad);
            object = element != null ? XmlElementStorageKt.normalizeRootName(element) : null;
        }
        Element serializedStateAfterLoad = object;
        this.storage.archiveState(this.storageData, this.componentName, serializedStateAfterLoad);
    }

    public StateGetter(@NotNull PersistentStateComponent<S> component, @NotNull String componentName, @NotNull T storageData, @NotNull Class<S> stateClass, @NotNull StorageBaseEx<T> storage2) {
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        Intrinsics.checkParameterIsNotNull(storage2, (String)"storage");
        this.component = component;
        this.componentName = componentName;
        this.storageData = storageData;
        this.stateClass = stateClass;
        this.storage = storage2;
    }
}

