/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.Nullable;

public class AdjustArrayRangeAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        if (debuggerContext == null) {
            return;
        }
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        Project project = debuggerContext.getProject();
        final XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        if (node == null) {
            return;
        }
        final XValue container = (XValue)node.getValueContainer();
        if (!(container instanceof JavaValue)) {
            return;
        }
        final ValueDescriptorImpl descriptor = ((JavaValue)container).getDescriptor();
        ArrayRenderer renderer = AdjustArrayRangeAction.getArrayRenderer(descriptor);
        if (renderer == null) {
            return;
        }
        String title = node.getName();
        final ArrayRenderer clonedRenderer = renderer.clone();
        clonedRenderer.setForced(true);
        if (ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new NamedArrayConfigurable(title, clonedRenderer))) {
            debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

                @Override
                public void contextAction() throws Exception {
                    CompoundNodeRenderer compoundRenderer;
                    ChildrenRenderer childrenRenderer;
                    Renderer lastRenderer = descriptor.getLastRenderer();
                    if (lastRenderer instanceof ArrayRenderer) {
                        ((JavaValue)container).setRenderer(clonedRenderer, node);
                    } else if (lastRenderer instanceof CompoundNodeRenderer && (childrenRenderer = (compoundRenderer = (CompoundNodeRenderer)lastRenderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer) {
                        ExpressionChildrenRenderer.setPreferableChildrenRenderer(descriptor, clonedRenderer);
                        ((JavaValue)container).reBuild(node);
                    }
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        XValue container;
        boolean enable = false;
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        if (node != null && (container = (XValue)node.getValueContainer()) instanceof JavaValue) {
            ValueDescriptorImpl descriptor = ((JavaValue)container).getDescriptor();
            enable = AdjustArrayRangeAction.getArrayRenderer(descriptor) != null;
        }
        e.getPresentation().setVisible(enable);
    }

    @Nullable
    private static ArrayRenderer getArrayRenderer(ValueDescriptorImpl descriptor) {
        NodeRenderer lastChildrenRenderer;
        Renderer lastRenderer = descriptor.getLastRenderer();
        if (lastRenderer instanceof ArrayRenderer) {
            return (ArrayRenderer)lastRenderer;
        }
        if (lastRenderer instanceof CompoundNodeRenderer && ((CompoundNodeRenderer)lastRenderer).getChildrenRenderer() instanceof ExpressionChildrenRenderer && (lastChildrenRenderer = ExpressionChildrenRenderer.getLastChildrenRenderer(descriptor)) instanceof ArrayRenderer) {
            return (ArrayRenderer)lastChildrenRenderer;
        }
        return null;
    }

    private static String createNodeTitle(String prefix, DebuggerTreeNodeImpl node) {
        if (node != null) {
            DebuggerTreeNodeImpl parent = node.getParent();
            NodeDescriptorImpl descriptor = parent.getDescriptor();
            if (descriptor instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)descriptor).isArray()) {
                int index = parent.getIndex(node);
                return AdjustArrayRangeAction.createNodeTitle(prefix, parent) + "[" + index + "]";
            }
            String name = node.getDescriptor() != null ? node.getDescriptor().getName() : null;
            return name != null ? prefix + " " + name : prefix;
        }
        return prefix;
    }

    private static class NamedArrayConfigurable
    extends ArrayRendererConfigurable
    implements Configurable {
        private final String myTitle;

        public NamedArrayConfigurable(String title, ArrayRenderer renderer) {
            super(renderer);
            this.myTitle = title;
        }

        public String getDisplayName() {
            return this.myTitle;
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

