/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;

public class DefaultSyntheticProvider
implements SyntheticTypeComponentProvider {
    public boolean isSynthetic(TypeComponent typeComponent) {
        String name = typeComponent.name();
        if (LambdaMethodFilter.isLambdaName(name)) {
            return false;
        }
        ReferenceType type = typeComponent.declaringType();
        if (type.name().contains("$$Lambda$")) {
            return true;
        }
        VirtualMachine machine = typeComponent.virtualMachine();
        if (machine != null && machine.canGetSyntheticAttribute()) {
            return typeComponent.isSynthetic();
        }
        return name.contains("$");
    }
}

