/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class TypeCastEvaluator
implements Evaluator {
    private final Evaluator myOperandEvaluator;
    private final String myCastType;
    private final boolean myIsPrimitive;

    public TypeCastEvaluator(Evaluator operandEvaluator, String castType, boolean isPrimitive) {
        this.myOperandEvaluator = operandEvaluator;
        this.myCastType = castType;
        this.myIsPrimitive = isPrimitive;
    }

    @Override
    public Modifier getModifier() {
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Type type;
        Value value = (Value)this.myOperandEvaluator.evaluate(context);
        if (value == null) {
            if (this.myIsPrimitive) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.null", (Object[])new Object[]{this.myCastType}));
            }
            return null;
        }
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        if (DebuggerUtils.isInteger((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myCastType, ((PrimitiveValue)value).longValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.myCastType}));
            }
        } else if (DebuggerUtils.isNumeric((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myCastType, ((PrimitiveValue)value).doubleValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.myCastType}));
            }
        } else if (value instanceof BooleanValue) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myCastType, ((BooleanValue)value).booleanValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.boolean", (Object[])new Object[]{this.myCastType}));
            }
        } else if (value instanceof CharValue) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myCastType, ((CharValue)value).charValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.char", (Object[])new Object[]{this.myCastType}));
            }
        } else if (value instanceof ObjectReference && !DebuggerUtils.instanceOf((Type)(type = value.type()), (String)this.myCastType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type.name(), this.myCastType}));
        }
        return value;
    }
}

