/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareClipboardWithSelectionAction
extends BaseShowDiffAction {
    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "getEditor"));
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            return editor;
        }
        editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            return editor;
        }
        return null;
    }

    @Nullable
    private static FileType getEditorFileType(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "getEditorFileType"));
        }
        DiffContent content = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT);
        if (content != null && content.getContentType() != null) {
            return content.getContentType();
        }
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (request instanceof ContentDiffRequest) {
            for (DiffContent diffContent : ((ContentDiffRequest)request).getContents()) {
                FileType type = diffContent.getContentType();
                if (type == null || type == UnknownFileType.INSTANCE) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "isAvailable"));
        }
        Editor editor = CompareClipboardWithSelectionAction.getEditor(e);
        return editor != null;
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "getDiffRequest"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Editor editor = CompareClipboardWithSelectionAction.getEditor(e);
        FileType editorFileType = CompareClipboardWithSelectionAction.getEditorFileType(e);
        assert (editor != null);
        DocumentContent content2 = CompareClipboardWithSelectionAction.createContent(project, editor, editorFileType);
        DocumentContent content1 = DiffContentFactory.getInstance().createClipboardContent(content2);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = CompareClipboardWithSelectionAction.createContentTitle(editor);
        String title = DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]);
        SimpleDiffRequest request = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
        if (editor.isViewer()) {
            request.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{false, true});
        }
        return request;
    }

    @NotNull
    private static DocumentContent createContent(@NotNull Project project, @NotNull Editor editor, @Nullable FileType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "createContent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "createContent"));
        }
        DocumentContent content = DiffContentFactory.getInstance().create(project, editor.getDocument(), type);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            TextRange range = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            content = new DocumentFragmentContent(project, content, range);
        }
        DocumentContent documentContent = content;
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "createContent"));
        }
        return documentContent;
    }

    @NotNull
    private static String createContentTitle(@NotNull Editor editor) {
        String title;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "createContentTitle"));
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        String string = title = file2 != null ? DiffRequestFactory.getInstance().getContentTitle(file2) : "Editor";
        if (editor.getSelectionModel().hasSelection()) {
            title = DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{title});
        }
        String string2 = title;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareClipboardWithSelectionAction", "createContentTitle"));
        }
        return string2;
    }
}

