/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DocumentsSynchronizer {
    @NotNull
    protected final Document myDocument1;
    @NotNull
    protected final Document myDocument2;
    @Nullable
    private final Project myProject;
    private volatile boolean myDuringModification;
    private final DocumentAdapter myListener1;
    private final DocumentAdapter myListener2;
    private final PropertyChangeListener myROListener;

    protected DocumentsSynchronizer(@Nullable Project project, @NotNull Document document1, @NotNull Document document2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/actions/DocumentsSynchronizer", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/actions/DocumentsSynchronizer", "<init>"));
        }
        this.myDuringModification = false;
        this.myListener1 = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (DocumentsSynchronizer.this.myDuringModification) {
                    return;
                }
                DocumentsSynchronizer.this.onDocumentChanged1(e);
            }
        };
        this.myListener2 = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (DocumentsSynchronizer.this.myDuringModification) {
                    return;
                }
                DocumentsSynchronizer.this.onDocumentChanged2(e);
            }
        };
        this.myROListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("writable".equals(evt.getPropertyName())) {
                    DocumentsSynchronizer.this.getDocument2().setReadOnly(!DocumentsSynchronizer.this.getDocument1().isWritable());
                }
            }
        };
        this.myProject = project;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
    }

    @NotNull
    public Document getDocument1() {
        Document document = this.myDocument1;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/DocumentsSynchronizer", "getDocument1"));
        }
        return document;
    }

    @NotNull
    public Document getDocument2() {
        Document document = this.myDocument2;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/DocumentsSynchronizer", "getDocument2"));
        }
        return document;
    }

    protected abstract void onDocumentChanged1(@NotNull DocumentEvent var1);

    protected abstract void onDocumentChanged2(@NotNull DocumentEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceString(final @NotNull Document document, final int startOffset, final int endOffset, final @NotNull CharSequence newText) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/actions/DocumentsSynchronizer", "replaceString"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/diff/actions/DocumentsSynchronizer", "replaceString"));
        }
        try {
            this.myDuringModification = true;
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    assert (endOffset <= document.getTextLength());
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            document.replaceString(startOffset, endOffset, newText);
                        }
                    });
                }
            }, "Synchronize document and its fragment", (Object)document);
        }
        finally {
            this.myDuringModification = false;
        }
    }

    public void startListen() {
        this.myDocument1.addDocumentListener((DocumentListener)this.myListener1);
        this.myDocument2.addDocumentListener((DocumentListener)this.myListener2);
        this.myDocument1.addPropertyChangeListener(this.myROListener);
    }

    public void stopListen() {
        this.myDocument1.removeDocumentListener((DocumentListener)this.myListener1);
        this.myDocument2.removeDocumentListener((DocumentListener)this.myListener2);
        this.myDocument1.removePropertyChangeListener(this.myROListener);
    }
}

