/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAwareDocumentContent
extends DocumentContentImpl {
    @Nullable
    private final Project myProject;

    public FileAwareDocumentContent(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType, @Nullable VirtualFile highlightFile, @Nullable LineSeparator separator, @Nullable Charset charset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/FileAwareDocumentContent", "<init>"));
        }
        super(document, fileType, highlightFile, separator, charset);
        this.myProject = project;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        if (this.myProject == null || this.getHighlightFile() == null) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.getHighlightFile(), offset);
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project, @NotNull String content, @NotNull FilePath path) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project).init(path).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project, @NotNull String content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project).init(highlightFile).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath path) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project).init(path).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project).init(highlightFile).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    private static class Builder {
        private final Project myProject;
        private Document myDocument;
        private FileType myFileType;
        private VirtualFile myHighlightFile;
        private LineSeparator mySeparator;
        private Charset myCharset;

        public Builder(@Nullable Project project) {
            this.myProject = project;
        }

        @NotNull
        private Builder init(@NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            this.myHighlightFile = path.getVirtualFile();
            this.myFileType = path.getFileType();
            this.myCharset = path.getCharset(this.myProject);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            return builder;
        }

        @NotNull
        private Builder init(@NotNull VirtualFile highlightFile) {
            if (highlightFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            this.myHighlightFile = highlightFile;
            this.myFileType = highlightFile.getFileType();
            this.myCharset = highlightFile.getCharset();
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            return builder;
        }

        @NotNull
        private Builder create(@NotNull String content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            this.mySeparator = StringUtil.detectSeparators((CharSequence)content);
            this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)content));
            this.myDocument.setReadOnly(true);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            return builder;
        }

        @NotNull
        private Builder create(@NotNull byte[] content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            assert (this.myCharset != null);
            Builder builder = this.create(CharsetToolkit.decodeString((byte[])content, (Charset)this.myCharset));
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            return builder;
        }

        @NotNull
        public FileAwareDocumentContent build() {
            if (FileTypes.UNKNOWN.equals(this.myFileType)) {
                this.myFileType = PlainTextFileType.INSTANCE;
            }
            FileAwareDocumentContent fileAwareDocumentContent = new FileAwareDocumentContent(this.myProject, this.myDocument, this.myFileType, this.myHighlightFile, this.mySeparator, this.myCharset);
            if (fileAwareDocumentContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "build"));
            }
            return fileAwareDocumentContent;
        }
    }
}

