/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffTool
implements FrameDiffTool {
    public static final ErrorDiffTool INSTANCE = new ErrorDiffTool();

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/ErrorDiffTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool", "createComponent"));
        }
        MyViewer myViewer = new MyViewer(context, request);
        if (myViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool", "createComponent"));
        }
        return myViewer;
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/ErrorDiffTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool", "canShow"));
        }
        return true;
    }

    @NotNull
    public String getName() {
        if ("Error viewer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool", "getName"));
        }
        return "Error viewer";
    }

    private static class MyViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final DiffRequest myRequest;
        @NotNull
        private final JPanel myPanel;

        public MyViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "<init>"));
            }
            this.myContext = context;
            this.myRequest = request;
            this.myPanel = JBUI.Panels.simplePanel((Component)this.createComponent(request));
        }

        @NotNull
        private JComponent createComponent(@NotNull DiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
            }
            if (request instanceof MessageDiffRequest) {
                String message = ((MessageDiffRequest)request).getMessage();
                JPanel jPanel = DiffUtil.createMessagePanel(message);
                if (jPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
                }
                return jPanel;
            }
            if (request instanceof ComponentDiffRequest) {
                JComponent jComponent = ((ComponentDiffRequest)request).getComponent(this.myContext);
                if (jComponent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
                }
                return jComponent;
            }
            if (request instanceof ContentDiffRequest) {
                List contents = ((ContentDiffRequest)request).getContents();
                for (DiffContent content : contents) {
                    if (!(content instanceof FileContent) || !FileTypes.UNKNOWN.equals(content.getContentType())) continue;
                    VirtualFile file2 = ((FileContent)content).getFile();
                    UnknownFileTypeDiffRequest unknownFileTypeRequest = new UnknownFileTypeDiffRequest(file2, this.myRequest.getTitle());
                    JComponent jComponent = unknownFileTypeRequest.getComponent(this.myContext);
                    if (jComponent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
                    }
                    return jComponent;
                }
            }
            JPanel jPanel = DiffUtil.createMessagePanel("Can't show diff");
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
            }
            return jPanel;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "getComponent"));
            }
            return jPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            String fileName;
            if (this.myRequest instanceof UnknownFileTypeDiffRequest && (fileName = ((UnknownFileTypeDiffRequest)this.myRequest).getFileName()) != null && FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE && this.myContext instanceof DiffContextEx) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DiffContextEx)MyViewer.this.myContext).reloadDiffRequest();
                    }
                }, ModalityState.current());
            }
            FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "init"));
            }
            return toolbarComponents;
        }

        public void dispose() {
        }
    }
}

