/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/VcsLogAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        List details = log.getSelectedDetails();
        MultiMap<Repo, VcsFullCommitDetails> grouped = this.groupByRootWithCheck(project, details);
        assert (grouped != null);
        this.actionPerformed(project, grouped);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/VcsLogAction", "update"));
        }
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List details = log.getSelectedDetails();
        MultiMap<Repo, VcsFullCommitDetails> grouped = this.groupByRootWithCheck(project, details);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, VcsFullCommitDetails> var1);

    protected boolean isVisible(final @NotNull Project project, @NotNull MultiMap<Repo, VcsFullCommitDetails> grouped) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogAction", "isVisible"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dvcs/ui/VcsLogAction", "isVisible"));
        }
        return ContainerUtil.and((Iterable)grouped.keySet(), (Condition)new Condition<Repo>(){

            public boolean value(Repo repo) {
                AbstractRepositoryManager manager = VcsLogAction.this.getRepositoryManager(project);
                return !manager.isExternal((Repository)repo);
            }
        });
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, VcsFullCommitDetails> groupByRootWithCheck(@NotNull Project project, @NotNull List<VcsFullCommitDetails> commits) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogAction", "groupByRootWithCheck"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/ui/VcsLogAction", "groupByRootWithCheck"));
        }
        MultiMap map = MultiMap.create();
        for (VcsFullCommitDetails commit : commits) {
            Repo root = this.getRepositoryForRoot(project, commit.getRoot());
            if (root == null) {
                return null;
            }
            map.putValue(root, (Object)commit);
        }
        return map;
    }
}

